import { Users, Shield, Heart, MessageSquare } from "lucide-react";

export default function AboutSection() {
  return (
    <section id="about" className="py-20 bg-white dark:bg-gray-900">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-6">
            About LoveMedia Foundation
          </h2>
          <p className="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
            Serving communities across South Africa as a trusted non-profit organization
          </p>
        </div>

        <div className="grid lg:grid-cols-2 gap-12 items-center mb-20">
          <div className="order-2 lg:order-1">
            <img
              src="https://images.unsplash.com/photo-1559827260-dc66d52bef19?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1000&h=600"
              alt="South African coastal community gathering"
              className="rounded-2xl shadow-2xl w-full h-auto"
            />
          </div>
          <div className="order-1 lg:order-2">
            <h3 className="text-3xl font-bold text-gray-900 dark:text-white mb-6">
              Inform, Connect, and Empower
            </h3>
            <p className="text-lg text-gray-600 dark:text-gray-400 mb-6">
              At LoveMedia Foundation NPC, our mission is to <strong>inform, connect, and empower</strong> communities across South Africa. As a non-profit organisation, we are committed to delivering reliable local news, real-time safety alerts, open community dialogue, and carefully curated discounted products from sponsors.
            </p>
            <p className="text-lg text-gray-600 dark:text-gray-400 mb-8">
              Our sponsor partnerships allow us to offer wholesale rates with only a 5% administrative fee, saving our members thousands of rands monthly on essential products and services.
            </p>

            {/* Mission Values */}
            <div className="grid grid-cols-1 sm:grid-cols-2 gap-6">
              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-gradient-to-br from-red-500 to-pink-500 rounded-full flex items-center justify-center flex-shrink-0">
                  <Users className="w-6 h-6 text-white" />
                </div>
                <div>
                  <h4 className="font-semibold text-gray-900 dark:text-white mb-1">Community First</h4>
                  <p className="text-sm text-gray-600 dark:text-gray-400">People at the heart of everything we do</p>
                </div>
              </div>

              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-gradient-to-br from-blue-500 to-teal-500 rounded-full flex items-center justify-center flex-shrink-0">
                  <Shield className="w-6 h-6 text-white" />
                </div>
                <div>
                  <h4 className="font-semibold text-gray-900 dark:text-white mb-1">Trusted Information</h4>
                  <p className="text-sm text-gray-600 dark:text-gray-400">Reliable local news and real-time alerts</p>
                </div>
              </div>

              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-gradient-to-br from-orange-500 to-red-500 rounded-full flex items-center justify-center flex-shrink-0">
                  <Heart className="w-6 h-6 text-white" />
                </div>
                <div>
                  <h4 className="font-semibold text-gray-900 dark:text-white mb-1">Non-Profit Mission</h4>
                  <p className="text-sm text-gray-600 dark:text-gray-400">No commercial interests or bias</p>
                </div>
              </div>

              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-gradient-to-br from-green-500 to-blue-500 rounded-full flex items-center justify-center flex-shrink-0">
                  <MessageSquare className="w-6 h-6 text-white" />
                </div>
                <div>
                  <h4 className="font-semibold text-gray-900 dark:text-white mb-1">Open Dialogue</h4>
                  <p className="text-sm text-gray-600 dark:text-gray-400">Transparent communication</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
