import { Button } from "@/components/ui/button";
import { Card, CardContent } from "@/components/ui/card";
import { MessageSquare, AlertTriangle, Home, Heart, Users, ExternalLink, Tag } from "lucide-react";

export default function CommunitySection() {
  const whatsappGroups = [
    {
      name: "LoveBallito Discussions",
      members: "2,500+",
      description: "Join our most active community discussion group for local news, events, business recommendations, sponsor deals, and general conversations.",
      url: "https://chat.whatsapp.com/Gie3EUoDqET7ERhX6oYVJv",
      icon: MessageSquare,
      color: "from-green-400 to-green-600"
    },
    {
      name: "LoveBallito Alerts",
      members: "1,800+",
      description: "Stay safe with real-time safety alerts, emergency updates, power outages, road closures, and important community notifications.",
      url: "https://chat.whatsapp.com/LoeF2bP6i5B1zrnmhCpXED",
      icon: AlertTriangle,
      color: "from-red-400 to-red-600"
    },
    {
      name: "LoveBallito Accommodation",
      members: "1,200+",
      description: "Find and share accommodation options - from holiday rentals and Airbnb listings to permanent housing, flatmates, and property sales.",
      url: "https://chat.whatsapp.com/FeVxRgHSnuXKJsKUBQJmr2",
      icon: Home,
      color: "from-blue-400 to-blue-600"
    },
    {
      name: "Love South Africa Christian",
      members: "800+",
      description: "Connect with the Christian community across South Africa, share faith-based events, church services, prayer requests, and build spiritual connections.",
      url: "https://chat.whatsapp.com/KyoF3ZbaNiqBsweTf0H2y0",
      icon: Heart,
      color: "from-purple-400 to-purple-600"
    },
    {
      name: "Love South Africa Discussions",
      members: "1,500+",
      description: "Join our nationwide South African community for broader discussions, news sharing, and connecting with fellow South Africans across all provinces.",
      url: "https://chat.whatsapp.com/BuUCq6pBGEC9EUMP6Lh4OH",
      icon: MessageSquare,
      color: "from-orange-400 to-orange-600"
    },
    {
      name: "Love South Africa Discounts",
      members: "500+",
      description: "Exclusive group for deep product discounts negotiated with our sponsors. Save thousands monthly with wholesale pricing plus only 5% admin fee.",
      url: "https://chat.whatsapp.com/E7N51DNzSN63OSJ0FCG3iV",
      icon: Tag,
      color: "from-yellow-400 to-yellow-600"
    }
  ];

  return (
    <section id="community" className="py-12 bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-800 dark:to-gray-900">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="text-center mb-16">
          <h2 className="text-4xl lg:text-5xl font-bold text-gray-900 dark:text-white mb-6">
            Join South Africa's Largest WhatsApp Community
          </h2>
          <p className="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
            Connect with over <strong>12,000 neighbors</strong> across South Africa and access exclusive discounts that save thousands monthly
          </p>
        </div>

        {/* WhatsApp Groups Grid */}
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
          {whatsappGroups.map((group) => {
            const IconComponent = group.icon;
            return (
              <Card key={group.name} className="bg-white dark:bg-gray-800 hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                <CardContent className="p-8">
                  <div className="flex items-center gap-4 mb-6">
                    <div className={`w-16 h-16 bg-gradient-to-br ${group.color} rounded-full flex items-center justify-center`}>
                      <IconComponent className="w-8 h-8 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-bold text-gray-900 dark:text-white">{group.name}</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">{group.members} members</p>
                    </div>
                  </div>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    {group.description}
                  </p>
                  <Button
                    className="w-full bg-green-500 hover:bg-green-600 text-white"
                    asChild
                  >
                    <a href={group.url} target="_blank" rel="noopener noreferrer">
                      <MessageSquare className="w-4 h-4 mr-2" />
                      Join Group
                      <ExternalLink className="w-4 h-4 ml-2" />
                    </a>
                  </Button>
                </CardContent>
              </Card>
            );
          })}
        </div>

        {/* Community Image */}
        <div className="text-center">
          <img
            src="https://images.unsplash.com/photo-1580060839134-75a5edca2e99?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1200&h=400"
            alt="Beautiful view of Table Mountain in Cape Town, South Africa"
            className="rounded-2xl shadow-2xl w-full h-64 object-cover"
          />
        </div>
      </div>
    </section>
  );
}
