import { Heart, Facebook, MessageSquare, Mail, MapPin, Clock } from "lucide-react";

export default function Footer() {
  return (
    <footer className="bg-gray-900 text-white py-12">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Organization Info */}
          <div>
            <div className="flex items-center space-x-3 mb-4">
              <div className="w-10 h-10 bg-gradient-to-br from-red-500 to-pink-500 rounded-full flex items-center justify-center">
                <Heart className="w-5 h-5 text-white" />
              </div>
              <div>
                <h3 className="text-lg font-bold">LoveMedia Foundation</h3>
                <p className="text-xs text-gray-400">NPC Registration</p>
              </div>
            </div>
            <p className="text-gray-400 text-sm mb-4">
              Connecting Ballito one story at a time. A non-profit organization serving the North Coast of KwaZulu-Natal.
            </p>
            <div className="flex space-x-4">
              <a
                href="https://www.facebook.com/groups/loveballito"
                target="_blank"
                rel="noopener noreferrer"
                className="text-gray-400 hover:text-white transition-colors"
              >
                <Facebook className="w-5 h-5" />
              </a>
              <a
                href="https://chat.whatsapp.com/Gie3EUoDqET7ERhX6oYVJv"
                target="_blank"
                rel="noopener noreferrer"
                className="text-gray-400 hover:text-white transition-colors"
              >
                <MessageSquare className="w-5 h-5" />
              </a>
            </div>
          </div>

          {/* Quick Links */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Quick Links</h4>
            <ul className="space-y-2 text-sm">
              <li>
                <a href="/" className="text-gray-400 hover:text-white transition-colors">
                  Home
                </a>
              </li>
              <li>
                <a href="/#about" className="text-gray-400 hover:text-white transition-colors">
                  About Us
                </a>
              </li>
              <li>
                <a href="/community" className="text-gray-400 hover:text-white transition-colors">
                  Community
                </a>
              </li>
              <li>
                <a href="/directory" className="text-gray-400 hover:text-white transition-colors">
                  Business Directory
                </a>
              </li>
              <li>
                <a href="/#contact" className="text-gray-400 hover:text-white transition-colors">
                  Contact
                </a>
              </li>
              <li>
                <a href="/terms" className="text-gray-400 hover:text-white transition-colors">
                  Terms of Service & Privacy Policy
                </a>
              </li>
            </ul>
          </div>

          {/* Community */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Community</h4>
            <ul className="space-y-2 text-sm">
              <li>
                <a
                  href="https://chat.whatsapp.com/Gie3EUoDqET7ERhX6oYVJv"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  LoveBallito Discussions
                </a>
              </li>
              <li>
                <a
                  href="https://chat.whatsapp.com/LoeF2bP6i5B1zrnmhCpXED"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  LoveBallito Alerts
                </a>
              </li>
              <li>
                <a
                  href="https://chat.whatsapp.com/FeVxRgHSnuXKJsKUBQJmr2"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  LoveBallito Accommodation
                </a>
              </li>
              <li>
                <a
                  href="https://chat.whatsapp.com/KyoF3ZbaNiqBsweTf0H2y0"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="text-gray-400 hover:text-white transition-colors"
                >
                  Love South Africa Christian
                </a>
              </li>
            </ul>
          </div>

          {/* Contact Info */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Contact</h4>
            <ul className="space-y-2 text-sm text-gray-400">
              <li className="flex items-center gap-2">
                <Mail className="w-4 h-4" />
                <a
                  href="mailto:admin@lovemedia.org.za"
                  className="hover:text-white transition-colors"
                >
                  admin@lovemedia.org.za
                </a>
              </li>
              <li className="flex items-center gap-2">
                <MapPin className="w-4 h-4" />
                <span>Ballito, KwaZulu-Natal</span>
              </li>
              <li className="flex items-center gap-2">
                <Clock className="w-4 h-4" />
                <span>24hr response time</span>
              </li>
            </ul>
          </div>
        </div>

        <div className="border-t border-gray-800 mt-8 pt-8 text-center">
          <p className="text-gray-400 text-sm">
            © 2024 LoveMedia Foundation NPC. All rights reserved. | Serving Ballito & North Coast KwaZulu-Natal
          </p>
        </div>
      </div>
    </footer>
  );
}
