import { Button } from "@/components/ui/button";
import { Heart, MessageSquare, ArrowDown } from "lucide-react";
import { RecommendedBusinesses } from "@/components/recommended-businesses";

export default function HeroSection() {
  const scrollToSection = (sectionId: string) => {
    const element = document.getElementById(sectionId);
    if (element) {
      element.scrollIntoView({ behavior: 'smooth' });
    }
  };

  return (
    <section className="pt-16 min-h-screen bg-gradient-to-br from-red-500 via-pink-500 to-orange-400 bg-[length:200%_200%] animate-gradient relative overflow-hidden">
      {/* Background Elements */}
      <div className="absolute inset-0 opacity-10">
        <div className="absolute top-1/4 left-1/4 w-64 h-64 bg-white rounded-full blur-3xl animate-pulse"></div>
        <div className="absolute bottom-1/4 right-1/4 w-96 h-96 bg-white rounded-full blur-3xl animate-pulse" style={{animationDelay: '2s'}}></div>
      </div>

      <div className="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div className="text-center">
          <div className="animate-fade-in-up">
            <h1 className="text-5xl lg:text-7xl font-black text-white mb-4 leading-tight">
              Connecting South Africa<br />
              <span className="bg-gradient-to-r from-white to-gray-200 bg-clip-text text-transparent">
                One Community at a Time
              </span>
            </h1>
            <p className="text-2xl lg:text-3xl text-white/95 mb-6 font-semibold">
              Join South Africa's Largest WhatsApp Community
            </p>
            <p className="text-lg lg:text-xl text-white/80 mb-8 max-w-3xl mx-auto font-light">
              Your trusted source for local news, community alerts, and discounted products from sponsors that save members thousands of rands monthly
            </p>
          </div>

          <div className="flex flex-col sm:flex-row gap-4 justify-center items-center animate-fade-in-up" style={{animationDelay: '0.3s'}}>
            <Button
              onClick={() => scrollToSection('about')}
              className="bg-white text-red-500 hover:bg-gray-100 px-8 py-4 rounded-full font-semibold text-lg shadow-xl hover:shadow-2xl transform hover:scale-105 transition-all duration-200 flex items-center gap-2"
            >
              <span>Learn More</span>
              <ArrowDown className="w-5 h-5" />
            </Button>
            <Button
              onClick={() => scrollToSection('community')}
              className="border-2 border-white bg-transparent text-white hover:bg-white hover:text-red-500 px-8 py-4 rounded-full font-semibold text-lg backdrop-blur-sm transition-all duration-200 flex items-center gap-2"
              data-testid="button-join-community"
            >
              <MessageSquare className="w-5 h-5" />
              <span>Join Our Community</span>
            </Button>
          </div>

          {/* Recommended Businesses */}
          <RecommendedBusinesses />

          {/* Stats */}
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mt-12 animate-fade-in-up" style={{animationDelay: '0.6s'}}>
            <div className="text-center">
              <div className="text-4xl font-bold text-white mb-2">12,000+</div>
              <div className="text-white/80">Community Members</div>
            </div>
            <div className="text-center">
              <div className="text-4xl font-bold text-white mb-2">6</div>
              <div className="text-white/80">WhatsApp Groups</div>
            </div>
            <div className="text-center">
              <div className="text-4xl font-bold text-white mb-2">24/7</div>
              <div className="text-white/80">Community Support</div>
            </div>
          </div>
        </div>
      </div>

      {/* Scroll indicator */}
      <div className="absolute bottom-8 left-1/2 transform -translate-x-1/2 animate-bounce">
        <div className="w-6 h-10 border-2 border-white/50 rounded-full flex justify-center">
          <div className="w-1 h-3 bg-white/50 rounded-full animate-pulse mt-2"></div>
        </div>
      </div>
    </section>
  );
}
