import Navigation from "@/components/navigation";
import Footer from "@/components/footer";
import { Card, CardContent } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { 
  MessageSquare, 
  Users, 
  AlertTriangle, 
  Home, 
  Heart, 
  ExternalLink 
} from "lucide-react";

export default function CommunityPage() {
  const whatsappGroups = [
    {
      name: "LoveBallito Discussions",
      members: "2,500+",
      description: "Join our most active community discussion group for local news, events, business recommendations, sponsor deals, and general conversations.",
      url: "https://chat.whatsapp.com/Gie3EUoDqET7ERhX6oYVJv",
      icon: MessageSquare,
      color: "from-green-400 to-green-600"
    },
    {
      name: "LoveBallito Alerts",
      members: "1,800+",
      description: "Stay safe with real-time safety alerts, emergency updates, power outages, road closures, and important community notifications.",
      url: "https://chat.whatsapp.com/LoeF2bP6i5B1zrnmhCpXED",
      icon: AlertTriangle,
      color: "from-red-400 to-red-600"
    },
    {
      name: "LoveBallito Accommodation",
      members: "1,200+",
      description: "Find and share accommodation options - from holiday rentals and Airbnb listings to permanent housing, flatmates, and property sales.",
      url: "https://chat.whatsapp.com/FeVxRgHSnuXKJsKUBQJmr2",
      icon: Home,
      color: "from-blue-400 to-blue-600"
    },
    {
      name: "Love South Africa Christian",
      members: "800+",
      description: "Connect with the Christian community across South Africa, share faith-based events, church services, prayer requests, and build spiritual connections.",
      url: "https://chat.whatsapp.com/KyoF3ZbaNiqBsweTf0H2y0",
      icon: Heart,
      color: "from-purple-400 to-purple-600"
    },
    {
      name: "Love South Africa Discussions",
      members: "1,500+",
      description: "Join our nationwide South African community for broader discussions, news sharing, and connecting with fellow South Africans across all provinces.",
      url: "https://chat.whatsapp.com/BuUCq6pBGEC9EUMP6Lh4OH",
      icon: MessageSquare,
      color: "from-orange-400 to-orange-600"
    }
  ];

  return (
    <div className="min-h-screen bg-white dark:bg-gray-900">
      <Navigation />
      
      {/* Hero Section */}
      <section className="pt-16 bg-gradient-to-br from-red-500 via-pink-500 to-orange-400 relative overflow-hidden">
        <div className="absolute inset-0 opacity-10">
          <div className="absolute top-1/4 left-1/4 w-64 h-64 bg-white rounded-full blur-3xl animate-pulse"></div>
          <div className="absolute bottom-1/4 right-1/4 w-96 h-96 bg-white rounded-full blur-3xl animate-pulse" style={{animationDelay: '2s'}}></div>
        </div>

        <div className="relative z-10 max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
          <div className="text-center text-white">
            <h1 className="text-4xl lg:text-6xl font-bold mb-6">
              Join Our Community
            </h1>
            <p className="text-xl lg:text-2xl mb-8 max-w-3xl mx-auto font-light text-white/90">
              Connect with over 12,000 neighbors across South Africa and access exclusive discounts that save thousands monthly
            </p>
            
            {/* Community Stats */}
            <div className="grid grid-cols-1 md:grid-cols-3 gap-8 max-w-2xl mx-auto">
              <div className="text-center">
                <div className="text-3xl font-bold">12,000+</div>
                <div className="text-white/80">Active Members</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold">5</div>
                <div className="text-white/80">WhatsApp Groups</div>
              </div>
              <div className="text-center">
                <div className="text-3xl font-bold">24/7</div>
                <div className="text-white/80">Community Support</div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* WhatsApp Groups Section */}
      <section className="py-20 bg-gray-50 dark:bg-gray-800">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-6">
              WhatsApp Community Groups
            </h2>
            <p className="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
              Choose the groups that match your interests and stay connected with your community
            </p>
          </div>

          {isLoading ? (
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              {[...Array(6)].map((_, i) => (
                <Card key={i} className="animate-pulse">
                  <CardContent className="p-8">
                    <div className="w-16 h-16 bg-gray-200 dark:bg-gray-700 rounded-full mb-6"></div>
                    <div className="h-6 bg-gray-200 dark:bg-gray-700 rounded mb-2"></div>
                    <div className="h-4 bg-gray-200 dark:bg-gray-700 rounded mb-4"></div>
                    <div className="h-20 bg-gray-200 dark:bg-gray-700 rounded mb-6"></div>
                    <div className="h-10 bg-gray-200 dark:bg-gray-700 rounded"></div>
                  </CardContent>
                </Card>
              ))}
            </div>
          ) : (
            <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
              {/* Predefined WhatsApp Groups */}
              <Card className="hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                <CardContent className="p-8">
                  <div className="flex items-center gap-4 mb-6">
                    <div className="w-16 h-16 bg-gradient-to-br from-green-400 to-green-600 rounded-full flex items-center justify-center">
                      <MessageSquare className="w-8 h-8 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-bold text-gray-900 dark:text-white">LoveMedia Discussions</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">2,500+ members</p>
                    </div>
                  </div>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    Join South Africa's most active community discussion group for local news, events, business recommendations, sponsor deals, and general conversations.
                  </p>
                  <Button 
                    className="w-full bg-green-500 hover:bg-green-600" 
                    asChild
                  >
                    <a href="https://chat.whatsapp.com/Gie3EUoDqET7ERhX6oYVJv" target="_blank" rel="noopener noreferrer">
                      <MessageSquare className="w-4 h-4 mr-2" />
                      Join Group
                      <ExternalLink className="w-4 h-4 ml-2" />
                    </a>
                  </Button>
                </CardContent>
              </Card>

              <Card className="hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                <CardContent className="p-8">
                  <div className="flex items-center gap-4 mb-6">
                    <div className="w-16 h-16 bg-gradient-to-br from-red-400 to-red-600 rounded-full flex items-center justify-center">
                      <AlertTriangle className="w-8 h-8 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-bold text-gray-900 dark:text-white">LoveMedia Alerts</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">1,800+ members</p>
                    </div>
                  </div>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    Stay safe with real-time safety alerts, emergency updates, power outages, road closures, and important community notifications across South Africa.
                  </p>
                  <Button 
                    className="w-full bg-green-500 hover:bg-green-600" 
                    asChild
                  >
                    <a href="https://chat.whatsapp.com/LoeF2bP6i5B1zrnmhCpXED" target="_blank" rel="noopener noreferrer">
                      <MessageSquare className="w-4 h-4 mr-2" />
                      Join Group
                      <ExternalLink className="w-4 h-4 ml-2" />
                    </a>
                  </Button>
                </CardContent>
              </Card>

              <Card className="hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                <CardContent className="p-8">
                  <div className="flex items-center gap-4 mb-6">
                    <div className="w-16 h-16 bg-gradient-to-br from-blue-400 to-blue-600 rounded-full flex items-center justify-center">
                      <Home className="w-8 h-8 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-bold text-gray-900 dark:text-white">LoveMedia Accommodation</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">1,200+ members</p>
                    </div>
                  </div>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    Find and share accommodation options across South Africa - from holiday rentals and Airbnb listings to permanent housing, flatmates, and property sales.
                  </p>
                  <Button 
                    className="w-full bg-green-500 hover:bg-green-600" 
                    asChild
                  >
                    <a href="https://chat.whatsapp.com/FeVxRgHSnuXKJsKUBQJmr2" target="_blank" rel="noopener noreferrer">
                      <MessageSquare className="w-4 h-4 mr-2" />
                      Join Group
                      <ExternalLink className="w-4 h-4 ml-2" />
                    </a>
                  </Button>
                </CardContent>
              </Card>

              <Card className="hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                <CardContent className="p-8">
                  <div className="flex items-center gap-4 mb-6">
                    <div className="w-16 h-16 bg-gradient-to-br from-purple-400 to-purple-600 rounded-full flex items-center justify-center">
                      <Heart className="w-8 h-8 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-bold text-gray-900 dark:text-white">LoveMedia Christian</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">800+ members</p>
                    </div>
                  </div>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    Connect with the Christian community across South Africa, share faith-based events, church services, prayer requests, and build spiritual connections.
                  </p>
                  <Button 
                    className="w-full bg-green-500 hover:bg-green-600" 
                    asChild
                  >
                    <a href="https://chat.whatsapp.com/KyoF3ZbaNiqBsweTf0H2y0" target="_blank" rel="noopener noreferrer">
                      <MessageSquare className="w-4 h-4 mr-2" />
                      Join Group
                      <ExternalLink className="w-4 h-4 ml-2" />
                    </a>
                  </Button>
                </CardContent>
              </Card>

              {/* Facebook Group */}
              <Card className="hover:shadow-xl transition-all duration-300 transform hover:scale-105 md:col-span-2 lg:col-span-1">
                <CardContent className="p-8">
                  <div className="flex items-center gap-4 mb-6">
                    <div className="w-16 h-16 bg-gradient-to-br from-blue-500 to-blue-700 rounded-full flex items-center justify-center">
                      <Users className="w-8 h-8 text-white" />
                    </div>
                    <div>
                      <h3 className="text-xl font-bold text-gray-900 dark:text-white">Facebook Community</h3>
                      <p className="text-sm text-gray-600 dark:text-gray-400">3,000+ members</p>
                    </div>
                  </div>
                  <p className="text-gray-600 dark:text-gray-400 mb-6">
                    Join our Facebook group for broader South African community discussions, photo sharing, local business promotions, sponsor deals, and event announcements.
                  </p>
                  <Button 
                    className="w-full bg-blue-600 hover:bg-blue-700" 
                    asChild
                  >
                    <a href="https://www.facebook.com/groups/loveballito" target="_blank" rel="noopener noreferrer">
                      <Users className="w-4 h-4 mr-2" />
                      Join on Facebook
                      <ExternalLink className="w-4 h-4 ml-2" />
                    </a>
                  </Button>
                </CardContent>
              </Card>

              {/* Additional groups from database */}
              {whatsappGroups?.map((group: any) => (
                <Card key={group.id} className="hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                  <CardContent className="p-8">
                    <div className="flex items-center gap-4 mb-6">
                      <div className="w-16 h-16 bg-gradient-to-br from-green-400 to-green-600 rounded-full flex items-center justify-center">
                        <MessageSquare className="w-8 h-8 text-white" />
                      </div>
                      <div>
                        <h3 className="text-xl font-bold text-gray-900 dark:text-white">{group.name}</h3>
                        <p className="text-sm text-gray-600 dark:text-gray-400">{group.memberCount}+ members</p>
                      </div>
                    </div>
                    <p className="text-gray-600 dark:text-gray-400 mb-6">
                      {group.description}
                    </p>
                    <Button 
                      className="w-full bg-green-500 hover:bg-green-600" 
                      asChild
                    >
                      <a href={group.groupUrl} target="_blank" rel="noopener noreferrer">
                        <MessageSquare className="w-4 h-4 mr-2" />
                        Join Group
                        <ExternalLink className="w-4 h-4 ml-2" />
                      </a>
                    </Button>
                  </CardContent>
                </Card>
              ))}
            </div>
          )}
        </div>
      </section>

      {/* Community Guidelines */}
      <section className="py-20 bg-white dark:bg-gray-900">
        <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
          <div className="text-center mb-16">
            <h2 className="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-6">
              Community Guidelines
            </h2>
            <p className="text-xl text-gray-600 dark:text-gray-400 max-w-3xl mx-auto">
              Help us maintain a positive and supportive community environment
            </p>
          </div>

          <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
            <Card>
              <CardHeader>
                <CardTitle className="flex items-center gap-2">
                  <Heart className="w-5 h-5 text-red-500" />
                  Be Respectful
                </CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-gray-600 dark:text-gray-400">
                  Treat all community members with kindness and respect. We're all neighbors here.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <CardTitle className="flex items-center gap-2">
                  <AlertTriangle className="w-5 h-5 text-orange-500" />
                  Stay On Topic
                </CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-gray-600 dark:text-gray-400">
                  Keep discussions relevant to the specific group's purpose and local community matters.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <CardTitle className="flex items-center gap-2">
                  <Users className="w-5 h-5 text-blue-500" />
                  Help Others
                </CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-gray-600 dark:text-gray-400">
                  Share helpful information and support community members when they need assistance.
                </p>
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <CardTitle className="flex items-center gap-2">
                  <MessageSquare className="w-5 h-5 text-green-500" />
                  No Spam
                </CardTitle>
              </CardHeader>
              <CardContent>
                <p className="text-gray-600 dark:text-gray-400">
                  Avoid excessive self-promotion and ensure all posts add value to the community.
                </p>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      <Footer />
    </div>
  );
}
