--
-- PostgreSQL database dump
--

-- Dumped from database version 16.9
-- Dumped by pg_dump version 16.9

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: businesses; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.businesses (
    id integer NOT NULL,
    name text NOT NULL,
    description text,
    category text NOT NULL,
    location text NOT NULL,
    contact_email text,
    contact_phone text,
    website text,
    whatsapp_number text,
    is_verified boolean DEFAULT false NOT NULL,
    rating integer DEFAULT 0,
    review_count integer DEFAULT 0,
    created_by integer,
    created_at timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.businesses OWNER TO neondb_owner;

--
-- Name: businesses_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.businesses_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.businesses_id_seq OWNER TO neondb_owner;

--
-- Name: businesses_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.businesses_id_seq OWNED BY public.businesses.id;


--
-- Name: contact_submissions; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.contact_submissions (
    id integer NOT NULL,
    name text NOT NULL,
    email text NOT NULL,
    subject text NOT NULL,
    message text NOT NULL,
    status text DEFAULT 'pending'::text NOT NULL,
    created_at timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.contact_submissions OWNER TO neondb_owner;

--
-- Name: contact_submissions_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.contact_submissions_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.contact_submissions_id_seq OWNER TO neondb_owner;

--
-- Name: contact_submissions_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.contact_submissions_id_seq OWNED BY public.contact_submissions.id;


--
-- Name: content; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.content (
    id integer NOT NULL,
    title text NOT NULL,
    body text NOT NULL,
    type text NOT NULL,
    status text DEFAULT 'draft'::text NOT NULL,
    priority text DEFAULT 'normal'::text NOT NULL,
    tags json DEFAULT '[]'::json,
    author_id integer,
    created_at timestamp without time zone DEFAULT now() NOT NULL,
    updated_at timestamp without time zone DEFAULT now() NOT NULL,
    published_at timestamp without time zone
);


ALTER TABLE public.content OWNER TO neondb_owner;

--
-- Name: content_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.content_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.content_id_seq OWNER TO neondb_owner;

--
-- Name: content_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.content_id_seq OWNED BY public.content.id;


--
-- Name: data_deals_customer_email_settings; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.data_deals_customer_email_settings (
    id integer NOT NULL,
    is_active boolean DEFAULT true,
    from_email text NOT NULL,
    from_name text DEFAULT 'LoveMedia Foundation'::text NOT NULL,
    reply_to_email text DEFAULT 'info@lovemedia.foundation'::text,
    subject text DEFAULT 'Thank You for Your Data Deal Order - {{orderNumber}}'::text NOT NULL,
    email_template text DEFAULT '<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; color: #333;">
  <div style="text-align: center; margin-bottom: 30px;">
    <h1 style="color: #e11d48; margin-bottom: 10px;">Thank You for Your Order!</h1>
    <p style="font-size: 18px; color: #666;">Order Number: <strong>{{orderNumber}}</strong></p>
  </div>

  <div style="background: linear-gradient(135deg, #3b82f6, #8b5cf6); color: white; padding: 20px; border-radius: 10px; margin-bottom: 30px;">
    <h2 style="margin: 0 0 10px 0;">Hi {{customerName}}!</h2>
    <p style="margin: 0; font-size: 16px;">Thank you for choosing our exclusive 4G/5G data deals through the LoveMedia Foundation partnership.</p>
  </div>

  <div style="background: #f8fafc; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
    <h3 style="color: #374151; margin-top: 0;">What Happens Next?</h3>
    <ul style="color: #6b7280; line-height: 1.6;">
      <li><strong>Order Processing:</strong> Your order is being processed by our partners at OpenWeb.co.za</li>
      <li><strong>Client Ambassador Contact:</strong> An OpenWeb Client Ambassador will reach out to you within 24-48 hours to complete your order setup</li>
      <li><strong>Installation:</strong> They will arrange delivery and installation at your specified address</li>
      <li><strong>Support:</strong> You''ll receive all the technical details and support information you need</li>
    </ul>
  </div>

  <div style="background: #fef2f2; border-left: 4px solid #ef4444; padding: 15px; margin-bottom: 20px;">
    <h4 style="color: #dc2626; margin: 0 0 10px 0;">💝 Your Impact</h4>
    <p style="margin: 0; color: #7f1d1d;">With your order, <strong>R200 will be donated</strong> to LoveMedia Foundation to support South African communities. Thank you for making a difference!</p>
  </div>

  <div style="border: 1px solid #e5e7eb; padding: 20px; border-radius: 8px; margin-bottom: 20px;">
    <h3 style="color: #374151; margin-top: 0;">Your Order Details</h3>
    <table style="width: 100%; border-collapse: collapse;">
      <tr>
        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;"><strong>Package:</strong></td>
        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;">{{packageName}}</td>
      </tr>
      <tr>
        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;"><strong>Monthly Cost:</strong></td>
        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;">R{{totalPrice}}</td>
      </tr>
      <tr>
        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;"><strong>Installation Address:</strong></td>
        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;">{{installationAddress}}</td>
      </tr>
      <tr>
        <td style="padding: 8px 0;"><strong>Contact Mobile:</strong></td>
        <td style="padding: 8px 0;">{{customerMobile}}</td>
      </tr>
    </table>
  </div>

  <div style="text-align: center; margin: 30px 0;">
    <p style="color: #6b7280; margin-bottom: 15px;">Need help or have questions?</p>
    <p style="margin: 5px 0;"><strong>Email:</strong> <a href="mailto:info@lovemedia.foundation" style="color: #3b82f6;">info@lovemedia.foundation</a></p>
    <p style="margin: 5px 0;"><strong>WhatsApp:</strong> Join our community groups for support</p>
  </div>

  <div style="text-align: center; padding: 20px; background: #f9fafb; border-radius: 8px; margin-top: 30px;">
    <p style="color: #6b7280; margin: 0; font-size: 14px;">Thank you for supporting LoveMedia Foundation and choosing premium data solutions!</p>
  </div>
</div>'::text NOT NULL,
    available_variables text DEFAULT 'orderNumber,orderDate,customerName,customerEmail,customerMobile,customerIdNumber,packageName,basePrice,premiumPrice,totalPrice,installationAddress,deliveryAddress,donationAmount'::text,
    created_by integer,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.data_deals_customer_email_settings OWNER TO neondb_owner;

--
-- Name: data_deals_customer_email_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.data_deals_customer_email_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.data_deals_customer_email_settings_id_seq OWNER TO neondb_owner;

--
-- Name: data_deals_customer_email_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.data_deals_customer_email_settings_id_seq OWNED BY public.data_deals_customer_email_settings.id;


--
-- Name: data_deals_email_settings; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.data_deals_email_settings (
    id integer NOT NULL,
    is_active boolean DEFAULT true,
    to_email text DEFAULT 'wow@openweb.email'::text NOT NULL,
    cc_email text DEFAULT 'info@lovemedia.foundation'::text,
    from_email text NOT NULL,
    from_name text DEFAULT 'LoveMedia Foundation'::text NOT NULL,
    reply_to_email text DEFAULT '{{customerEmail}}'::text,
    subject text DEFAULT 'New Data Deal Order - {{orderNumber}} - LoveMedia Foundation Partnership'::text NOT NULL,
    email_template text DEFAULT '<h2>New LoveMedia Foundation Data Deal Order</h2><p><strong>Order Number:</strong> {{orderNumber}}</p>'::text NOT NULL,
    available_variables text DEFAULT 'orderNumber,orderDate,customerName,customerEmail,customerMobile,customerIdNumber,installationAddress,deliveryAddress,packageName,basePrice,premiumPrice,totalPrice,upgradeToPremium,paymentMethodText,bank,accountNumber,accountType,branchCode,mandateSignature,donationAmount'::text,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    created_by integer
);


ALTER TABLE public.data_deals_email_settings OWNER TO neondb_owner;

--
-- Name: data_deals_email_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.data_deals_email_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.data_deals_email_settings_id_seq OWNER TO neondb_owner;

--
-- Name: data_deals_email_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.data_deals_email_settings_id_seq OWNED BY public.data_deals_email_settings.id;


--
-- Name: data_deals_orders; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.data_deals_orders (
    id integer NOT NULL,
    first_name text NOT NULL,
    surname text NOT NULL,
    email text NOT NULL,
    id_number text NOT NULL,
    mobile text NOT NULL,
    installation_address text NOT NULL,
    delivery_address text NOT NULL,
    package_id text NOT NULL,
    package_name text NOT NULL,
    base_price integer NOT NULL,
    upgrade_to_premium boolean DEFAULT false NOT NULL,
    premium_price integer DEFAULT 0,
    total_price integer NOT NULL,
    payment_method text NOT NULL,
    bank text NOT NULL,
    account_number text NOT NULL,
    account_type text NOT NULL,
    branch_code text NOT NULL,
    mandate_signature text NOT NULL,
    status text DEFAULT 'pending'::text NOT NULL,
    order_number text,
    sent_to_openweb boolean DEFAULT false NOT NULL,
    donation_amount integer DEFAULT 20000,
    created_at timestamp without time zone DEFAULT now() NOT NULL,
    processed_at timestamp without time zone
);


ALTER TABLE public.data_deals_orders OWNER TO neondb_owner;

--
-- Name: data_deals_orders_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.data_deals_orders_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.data_deals_orders_id_seq OWNER TO neondb_owner;

--
-- Name: data_deals_orders_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.data_deals_orders_id_seq OWNED BY public.data_deals_orders.id;


--
-- Name: email_campaigns; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.email_campaigns (
    id integer NOT NULL,
    subject text NOT NULL,
    content text NOT NULL,
    recipient_count integer NOT NULL,
    sent_count integer DEFAULT 0,
    failed_count integer DEFAULT 0,
    status text DEFAULT 'draft'::text NOT NULL,
    sent_by integer,
    created_at timestamp without time zone DEFAULT now() NOT NULL,
    sent_at timestamp without time zone
);


ALTER TABLE public.email_campaigns OWNER TO neondb_owner;

--
-- Name: email_campaigns_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.email_campaigns_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.email_campaigns_id_seq OWNER TO neondb_owner;

--
-- Name: email_campaigns_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.email_campaigns_id_seq OWNED BY public.email_campaigns.id;


--
-- Name: email_newsletters; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.email_newsletters (
    id integer NOT NULL,
    email text NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    created_at timestamp without time zone DEFAULT now() NOT NULL,
    unsubscribed_at timestamp without time zone
);


ALTER TABLE public.email_newsletters OWNER TO neondb_owner;

--
-- Name: email_newsletters_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.email_newsletters_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.email_newsletters_id_seq OWNER TO neondb_owner;

--
-- Name: email_newsletters_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.email_newsletters_id_seq OWNED BY public.email_newsletters.id;


--
-- Name: header_tags; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.header_tags (
    id integer NOT NULL,
    name text NOT NULL,
    type text NOT NULL,
    code text NOT NULL,
    priority integer DEFAULT 1,
    is_active boolean DEFAULT true,
    created_at timestamp without time zone DEFAULT now(),
    updated_at timestamp without time zone DEFAULT now(),
    created_by integer
);


ALTER TABLE public.header_tags OWNER TO neondb_owner;

--
-- Name: header_tags_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.header_tags_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.header_tags_id_seq OWNER TO neondb_owner;

--
-- Name: header_tags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.header_tags_id_seq OWNED BY public.header_tags.id;


--
-- Name: page_layouts; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.page_layouts (
    id integer NOT NULL,
    page_name text NOT NULL,
    sections jsonb NOT NULL,
    is_active boolean DEFAULT true,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    created_by integer
);


ALTER TABLE public.page_layouts OWNER TO neondb_owner;

--
-- Name: page_layouts_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.page_layouts_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.page_layouts_id_seq OWNER TO neondb_owner;

--
-- Name: page_layouts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.page_layouts_id_seq OWNED BY public.page_layouts.id;


--
-- Name: products; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.products (
    id integer NOT NULL,
    name text NOT NULL,
    description text,
    category text NOT NULL,
    wholesale_price integer,
    admin_fee_percentage integer DEFAULT 5,
    final_price integer,
    is_active boolean DEFAULT true NOT NULL,
    created_at timestamp without time zone DEFAULT now() NOT NULL,
    updated_at timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.products OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.products_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.products_id_seq OWNER TO neondb_owner;

--
-- Name: products_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.products_id_seq OWNED BY public.products.id;


--
-- Name: seo_settings; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.seo_settings (
    id integer NOT NULL,
    page_name character varying(255) NOT NULL,
    title character varying(255),
    description text,
    keywords text,
    og_title character varying(255),
    og_description text,
    og_image character varying(255),
    canonical_url character varying(255),
    noindex boolean DEFAULT false,
    created_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    updated_at timestamp without time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE public.seo_settings OWNER TO neondb_owner;

--
-- Name: seo_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.seo_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.seo_settings_id_seq OWNER TO neondb_owner;

--
-- Name: seo_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.seo_settings_id_seq OWNED BY public.seo_settings.id;


--
-- Name: session; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.session (
    sid character varying NOT NULL,
    sess json NOT NULL,
    expire timestamp(6) without time zone NOT NULL
);


ALTER TABLE public.session OWNER TO neondb_owner;

--
-- Name: smtp_config; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.smtp_config (
    id integer NOT NULL,
    host text NOT NULL,
    port integer NOT NULL,
    username text NOT NULL,
    password text NOT NULL,
    from_email text NOT NULL,
    from_name text NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    created_at timestamp without time zone DEFAULT now() NOT NULL,
    updated_at timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.smtp_config OWNER TO neondb_owner;

--
-- Name: smtp_config_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.smtp_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.smtp_config_id_seq OWNER TO neondb_owner;

--
-- Name: smtp_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.smtp_config_id_seq OWNED BY public.smtp_config.id;


--
-- Name: system_settings; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.system_settings (
    id integer NOT NULL,
    organization text DEFAULT 'LoveMedia Foundation NPC'::text NOT NULL,
    location text DEFAULT 'Ballito, North Coast, KwaZulu-Natal'::text NOT NULL,
    admin_fee text DEFAULT '5% on wholesale prices'::text NOT NULL,
    business_model text DEFAULT 'Non-profit with transparent pricing'::text NOT NULL,
    contact_email text DEFAULT 'info@lovemedia.foundation'::text,
    contact_phone text,
    website text DEFAULT 'https://lovemedia.foundation'::text,
    updated_at timestamp without time zone DEFAULT now() NOT NULL,
    updated_by integer
);


ALTER TABLE public.system_settings OWNER TO neondb_owner;

--
-- Name: system_settings_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.system_settings_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.system_settings_id_seq OWNER TO neondb_owner;

--
-- Name: system_settings_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.system_settings_id_seq OWNED BY public.system_settings.id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.users (
    id integer NOT NULL,
    username text NOT NULL,
    email text NOT NULL,
    password text NOT NULL,
    full_name text NOT NULL,
    role text DEFAULT 'client'::text NOT NULL,
    location text,
    is_active boolean DEFAULT true NOT NULL,
    created_at timestamp without time zone DEFAULT now() NOT NULL,
    last_login timestamp without time zone,
    first_name text,
    last_name text,
    mobile text,
    province text
);


ALTER TABLE public.users OWNER TO neondb_owner;

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.users_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.users_id_seq OWNER TO neondb_owner;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- Name: whatsapp_groups; Type: TABLE; Schema: public; Owner: neondb_owner
--

CREATE TABLE public.whatsapp_groups (
    id integer NOT NULL,
    name text NOT NULL,
    description text,
    group_url text NOT NULL,
    member_count integer DEFAULT 0,
    category text NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    created_at timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.whatsapp_groups OWNER TO neondb_owner;

--
-- Name: whatsapp_groups_id_seq; Type: SEQUENCE; Schema: public; Owner: neondb_owner
--

CREATE SEQUENCE public.whatsapp_groups_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.whatsapp_groups_id_seq OWNER TO neondb_owner;

--
-- Name: whatsapp_groups_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: neondb_owner
--

ALTER SEQUENCE public.whatsapp_groups_id_seq OWNED BY public.whatsapp_groups.id;


--
-- Name: businesses id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.businesses ALTER COLUMN id SET DEFAULT nextval('public.businesses_id_seq'::regclass);


--
-- Name: contact_submissions id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.contact_submissions ALTER COLUMN id SET DEFAULT nextval('public.contact_submissions_id_seq'::regclass);


--
-- Name: content id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.content ALTER COLUMN id SET DEFAULT nextval('public.content_id_seq'::regclass);


--
-- Name: data_deals_customer_email_settings id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.data_deals_customer_email_settings ALTER COLUMN id SET DEFAULT nextval('public.data_deals_customer_email_settings_id_seq'::regclass);


--
-- Name: data_deals_email_settings id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.data_deals_email_settings ALTER COLUMN id SET DEFAULT nextval('public.data_deals_email_settings_id_seq'::regclass);


--
-- Name: data_deals_orders id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.data_deals_orders ALTER COLUMN id SET DEFAULT nextval('public.data_deals_orders_id_seq'::regclass);


--
-- Name: email_campaigns id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.email_campaigns ALTER COLUMN id SET DEFAULT nextval('public.email_campaigns_id_seq'::regclass);


--
-- Name: email_newsletters id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.email_newsletters ALTER COLUMN id SET DEFAULT nextval('public.email_newsletters_id_seq'::regclass);


--
-- Name: header_tags id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.header_tags ALTER COLUMN id SET DEFAULT nextval('public.header_tags_id_seq'::regclass);


--
-- Name: page_layouts id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.page_layouts ALTER COLUMN id SET DEFAULT nextval('public.page_layouts_id_seq'::regclass);


--
-- Name: products id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.products ALTER COLUMN id SET DEFAULT nextval('public.products_id_seq'::regclass);


--
-- Name: seo_settings id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.seo_settings ALTER COLUMN id SET DEFAULT nextval('public.seo_settings_id_seq'::regclass);


--
-- Name: smtp_config id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.smtp_config ALTER COLUMN id SET DEFAULT nextval('public.smtp_config_id_seq'::regclass);


--
-- Name: system_settings id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.system_settings ALTER COLUMN id SET DEFAULT nextval('public.system_settings_id_seq'::regclass);


--
-- Name: users id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- Name: whatsapp_groups id; Type: DEFAULT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.whatsapp_groups ALTER COLUMN id SET DEFAULT nextval('public.whatsapp_groups_id_seq'::regclass);


--
-- Data for Name: businesses; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.businesses (id, name, description, category, location, contact_email, contact_phone, website, whatsapp_number, is_verified, rating, review_count, created_by, created_at) FROM stdin;
\.


--
-- Data for Name: contact_submissions; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.contact_submissions (id, name, email, subject, message, status, created_at) FROM stdin;
\.


--
-- Data for Name: content; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.content (id, title, body, type, status, priority, tags, author_id, created_at, updated_at, published_at) FROM stdin;
\.


--
-- Data for Name: data_deals_customer_email_settings; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.data_deals_customer_email_settings (id, is_active, from_email, from_name, reply_to_email, subject, email_template, available_variables, created_by, created_at, updated_at) FROM stdin;
1	t	noreply@lovemedia.foundation	LoveMedia Foundation	info@lovemedia.foundation	Thank You for Your Data Deal Order - {{orderNumber}}	<div style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; color: #333;">\n  <div style="text-align: center; margin-bottom: 30px;">\n    <h1 style="color: #e11d48; margin-bottom: 10px;">Thank You for Your Order!</h1>\n    <p style="font-size: 18px; color: #666;">Order Number: <strong>{{orderNumber}}</strong></p>\n  </div>\n\n  <div style="background: linear-gradient(135deg, #3b82f6, #8b5cf6); color: white; padding: 20px; border-radius: 10px; margin-bottom: 30px;">\n    <h2 style="margin: 0 0 10px 0;">Hi {{customerName}}!</h2>\n    <p style="margin: 0; font-size: 16px;">Thank you for choosing our exclusive 4G/5G data deals through the LoveMedia Foundation partnership.</p>\n  </div>\n\n  <div style="background: #f8fafc; padding: 20px; border-radius: 8px; margin-bottom: 20px;">\n    <h3 style="color: #374151; margin-top: 0;">What Happens Next?</h3>\n    <ul style="color: #6b7280; line-height: 1.6;">\n      <li><strong>Order Processing:</strong> Your order is being processed by our partners at OpenWeb.co.za</li>\n      <li><strong>Client Ambassador Contact:</strong> An OpenWeb Client Ambassador will reach out to you within 24-48 hours to complete your order setup</li>\n      <li><strong>Installation:</strong> They will arrange delivery and installation at your specified address</li>\n      <li><strong>Support:</strong> You'll receive all the technical details and support information you need</li>\n    </ul>\n  </div>\n\n  <div style="background: #fef2f2; border-left: 4px solid #ef4444; padding: 15px; margin-bottom: 20px;">\n    <h4 style="color: #dc2626; margin: 0 0 10px 0;">💝 Your Impact</h4>\n    <p style="margin: 0; color: #7f1d1d;">With your order, <strong>R200 will be donated</strong> to LoveMedia Foundation to support South African communities. Thank you for making a difference!</p>\n  </div>\n\n  <div style="border: 1px solid #e5e7eb; padding: 20px; border-radius: 8px; margin-bottom: 20px;">\n    <h3 style="color: #374151; margin-top: 0;">Your Order Details</h3>\n    <table style="width: 100%; border-collapse: collapse;">\n      <tr>\n        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;"><strong>Package:</strong></td>\n        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;">{{packageName}}</td>\n      </tr>\n      <tr>\n        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;"><strong>Monthly Cost:</strong></td>\n        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;">R{{totalPrice}}</td>\n      </tr>\n      <tr>\n        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;"><strong>Installation Address:</strong></td>\n        <td style="padding: 8px 0; border-bottom: 1px solid #f3f4f6;">{{installationAddress}}</td>\n      </tr>\n      <tr>\n        <td style="padding: 8px 0;"><strong>Contact Mobile:</strong></td>\n        <td style="padding: 8px 0;">{{customerMobile}}</td>\n      </tr>\n    </table>\n  </div>\n\n  <div style="text-align: center; margin: 30px 0;">\n    <p style="color: #6b7280; margin-bottom: 15px;">Need help or have questions?</p>\n    <p style="margin: 5px 0;"><strong>Email:</strong> <a href="mailto:info@lovemedia.foundation" style="color: #3b82f6;">info@lovemedia.foundation</a></p>\n    <p style="margin: 5px 0;"><strong>WhatsApp:</strong> Join our community groups for support</p>\n  </div>\n\n  <div style="text-align: center; padding: 20px; background: #f9fafb; border-radius: 8px; margin-top: 30px;">\n    <p style="color: #6b7280; margin: 0; font-size: 14px;">Thank you for supporting LoveMedia Foundation and choosing premium data solutions!</p>\n  </div>\n</div>	orderNumber,orderDate,customerName,customerEmail,customerMobile,customerIdNumber,packageName,basePrice,premiumPrice,totalPrice,installationAddress,deliveryAddress,donationAmount	1	2025-07-19 18:00:46.592197	2025-07-19 18:00:46.592197
\.


--
-- Data for Name: data_deals_email_settings; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.data_deals_email_settings (id, is_active, to_email, cc_email, from_email, from_name, reply_to_email, subject, email_template, available_variables, created_at, updated_at, created_by) FROM stdin;
1	t	wow@openweb.email	founder@lovemedia.org.za	founder@lovemedia.org.za	LoveMedia Foundation	{{customerEmail}}	New Data Deal Order - {{orderNumber}} - LoveMedia Foundation Partnership	<h2>New LoveMedia Foundation Data Deal Order</h2>\n<p><strong>Order Number:</strong> {{orderNumber}}</p>\n<p><strong>Order Date:</strong> {{orderDate}}</p>\n\n<h3>Customer Information</h3>\n<ul>\n  <li><strong>Name:</strong> {{customerName}}</li>\n  <li><strong>Email:</strong> {{customerEmail}}</li>\n  <li><strong>Mobile:</strong> {{customerMobile}}</li>\n  <li><strong>ID/Passport:</strong> {{customerIdNumber}}</li>\n</ul>\n\n<h3>Installation & Delivery</h3>\n<ul>\n  <li><strong>Installation Address:</strong><br>{{installationAddress}}</li>\n  <li><strong>Delivery Address:</strong><br>{{deliveryAddress}}</li>\n</ul>\n\n<h3>Package Details</h3>\n<ul>\n  <li><strong>Package:</strong> {{packageName}}</li>\n  <li><strong>Base Price:</strong> R{{basePrice}}</li>\n  {{#if upgradeToPremium}}<li><strong>Premium Upgrade:</strong> R{{premiumPrice}}</li>{{/if}}\n  <li><strong>Total Monthly Price:</strong> R{{totalPrice}}</li>\n</ul>\n\n<h3>Payment Information</h3>\n<ul>\n  <li><strong>Payment Method:</strong> {{paymentMethodText}}</li>\n  <li><strong>Bank:</strong> {{bank}}</li>\n  <li><strong>Account Number:</strong> {{accountNumber}}</li>\n  <li><strong>Account Type:</strong> {{accountType}}</li>\n  <li><strong>Branch Code:</strong> {{branchCode}}</li>\n  <li><strong>Electronic Mandate Signature:</strong> {{mandateSignature}}</li>\n</ul>\n\n<h3>LoveMedia Foundation Partnership</h3>\n<p><strong>Donation to LoveMedia Foundation:</strong> R{{donationAmount}}</p>\n<p>This order includes priority streaming & gaming protocols and exclusive discounts for LoveMedia Foundation members.</p>\n\n<hr>\n<p><em>This order was submitted through the LoveMedia Foundation platform and includes our partnership agreement for R{{donationAmount}} donation per order.</em></p>\n<p><strong>For questions contact:</strong> info@lovemedia.foundation</p>	orderNumber,orderDate,customerName,customerEmail,customerMobile,customerIdNumber,installationAddress,deliveryAddress,packageName,basePrice,premiumPrice,totalPrice,upgradeToPremium,paymentMethodText,bank,accountNumber,accountType,branchCode,mandateSignature,donationAmount	2025-07-19 14:17:17.795109	2025-07-19 16:48:44.142	1
\.


--
-- Data for Name: data_deals_orders; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.data_deals_orders (id, first_name, surname, email, id_number, mobile, installation_address, delivery_address, package_id, package_name, base_price, upgrade_to_premium, premium_price, total_price, payment_method, bank, account_number, account_type, branch_code, mandate_signature, status, order_number, sent_to_openweb, donation_amount, created_at, processed_at) FROM stdin;
1	Test	User	test@example.com	1234567890123	0123456789	123 Test Street, Test City, 1234	123 Test Street, Test City, 1234	uncapped-2mbps	Uncapped up to 2Mbps Data SIM - R337 pm	33700	f	0	33700	debit_order	FNB	12345678	cheque	250655	Test Signature	sent	LM-1752943932759-AUMW	t	20000	2025-07-19 16:52:12.781911	2025-07-19 16:52:12.889
2	John	Doe	john.doe@example.com	1234567890123	0123456789	456 Example Street, Example City, 5678	456 Example Street, Example City, 5678	uncapped-2mbps	Uncapped up to 2Mbps Data SIM - R337 pm	33700	t	18900	52600	debit_order	Standard Bank	87654321	savings	051001	John Doe Digital Signature	sent	LM-1752943951986-GCZQ	t	20000	2025-07-19 16:52:32.104502	2025-07-19 16:52:32.189
3	Sarah	Wilson	sarah.wilson@example.com	9876543210987	0987654321	789 Final Test Street, Cape Town, 8001	789 Final Test Street, Cape Town, 8001	uncapped-wildcard	Uncapped Wildcard - R427 pm	42700	f	0	42700	credit_card	Capitec Bank	11223344	savings	470010	Sarah Wilson Digital Auth	sent	LM-1752943977737-9ZNF	t	20000	2025-07-19 16:52:57.755672	2025-07-19 16:53:00.915
4	Keoma	Wright	ceo@openweb.co.za	8409205026086	0826987888	Test\nTest\nTest	Test\nTest\nTest	100gb-anytime	100GB Anytime Data - R299	29900	t	18900	48800	debit_order	ABSA	4064449626	cheque	632005	Keoma	sent	LM-1752945800861-UKWK	t	20000	2025-07-19 17:23:20.880439	2025-07-19 17:23:21.864
\.


--
-- Data for Name: email_campaigns; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.email_campaigns (id, subject, content, recipient_count, sent_count, failed_count, status, sent_by, created_at, sent_at) FROM stdin;
\.


--
-- Data for Name: email_newsletters; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.email_newsletters (id, email, is_active, created_at, unsubscribed_at) FROM stdin;
1	ceo@openweb.co.za	t	2025-07-18 13:53:32.686877	\N
\.


--
-- Data for Name: header_tags; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.header_tags (id, name, type, code, priority, is_active, created_at, updated_at, created_by) FROM stdin;
1	Google Analytics Conversion Tracking	analytics	<!-- Google tag (gtag.js) -->\n<script async src="https://www.googletagmanager.com/gtag/js?id=G-LGE4FN36G6"></script>\n<script>\n  window.dataLayer = window.dataLayer || [];\n  function gtag(){dataLayer.push(arguments);}\n  gtag('js', new Date());\n\n  gtag('config', 'G-LGE4FN36G6');\n</script>	1	t	2025-07-18 16:05:18.984964	2025-07-21 14:09:18.946	1
2	Shown	custom	<script defer src="https://shown.io/metrics/ZB0A5MXl0n" type="text/javascript"></script	2	t	2025-07-24 13:07:22.331898	2025-07-24 14:30:45.777	1
\.


--
-- Data for Name: page_layouts; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.page_layouts (id, page_name, sections, is_active, created_at, updated_at, created_by) FROM stdin;
1	home	[{"id": "hero", "type": "hero", "order": 1, "title": "Hero Section", "styles": {"margin": "0", "padding": "80px 20px", "textColor": "#ffffff", "background": "linear-gradient(135deg, #ef4444 0%, #ec4899 50%, #f97316 100%)"}, "content": {"stats": [{"label": "Community Members", "number": "6,000+"}, {"label": "WhatsApp Groups", "number": "5"}, {"label": "Community Support", "number": "24/7"}], "heading": "Connecting South Africa", "buttonLink": "#about", "buttonText": "Learn More", "subheading": "Join South Africa's Largest WhatsApp Community", "description": "Your trusted source for local news, community alerts, and discounted products from sponsors that save members thousands of rands monthly", "backgroundImage": ""}, "isVisible": true}, {"id": "community", "type": "community", "order": 2, "title": "Community Section", "styles": {"margin": "0", "padding": "60px 20px", "textColor": "#1f2937", "background": "linear-gradient(135deg, #f9fafb 0%, #e5e7eb 100%)"}, "content": {"groups": [{"url": "https://chat.whatsapp.com/invite/ballito-discussions", "name": "LoveBallito Discussions", "members": "2,500+", "description": "General community discussions, local news, and daily interactions for Ballito residents"}, {"url": "https://chat.whatsapp.com/invite/ballito-alerts", "name": "LoveBallito Alerts", "members": "1,800+", "description": "Emergency alerts, safety notifications, and urgent community announcements"}], "heading": "Join South Africa's Largest WhatsApp Community", "description": "Connect with over 6,000 neighbors across South Africa and access exclusive discounts that save thousands monthly"}, "isVisible": true}, {"id": "about", "type": "about", "order": 3, "title": "About Section", "styles": {"margin": "0", "padding": "60px 20px", "textColor": "#1f2937", "background": "#ffffff"}, "content": {"image": "https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1200&h=400", "heading": "About LoveMedia Foundation", "features": ["Community WhatsApp Groups", "Local News & Updates", "Exclusive Discounts", "24/7 Support"], "description": "LoveMedia Foundation is a non-profit organization dedicated to connecting communities across South Africa through digital platforms, local news, and exclusive member benefits."}, "isVisible": true}]	t	2025-07-18 14:49:25.519925	2025-07-18 14:50:23.873	1
\.


--
-- Data for Name: products; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.products (id, name, description, category, wholesale_price, admin_fee_percentage, final_price, is_active, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: seo_settings; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.seo_settings (id, page_name, title, description, keywords, og_title, og_description, og_image, canonical_url, noindex, created_at, updated_at) FROM stdin;
\.


--
-- Data for Name: session; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.session (sid, sess, expire) FROM stdin;
Yr1C1G5x_O1DT4WzpOL-DnQbnhbDwf9b	{"cookie":{"originalMaxAge":null,"expires":null,"httpOnly":true,"path":"/"},"passport":{"user":1}}	2025-07-26 09:57:14
\.


--
-- Data for Name: smtp_config; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.smtp_config (id, host, port, username, password, from_email, from_name, is_active, created_at, updated_at) FROM stdin;
1	smtp.gmail.com	587	founder@lovemedia.org.za	nhkx ymlg bwbs ygsc	founder@lovemedia.org.za	LoveMedia Foundation	t	2025-07-19 12:42:26.72836	2025-07-19 12:42:26.71
\.


--
-- Data for Name: system_settings; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.system_settings (id, organization, location, admin_fee, business_model, contact_email, contact_phone, website, updated_at, updated_by) FROM stdin;
1	LoveMedia Foundation NPC	South Africa	5% on wholesale prices	Non-profit with transparent pricing	admin@lovemedia.org.za	\N	https://lovemedia.org.za	2025-07-19 12:26:29.647	1
\.


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.users (id, username, email, password, full_name, role, location, is_active, created_at, last_login, first_name, last_name, mobile, province) FROM stdin;
1	ceo@openweb.co.za	ceo@openweb.co.za	404dd4f5bbfa825992186d60e0b4345fe86cbae1b5c9e0e32b50a8a76cdd4ab2900a591084bcf00437dd259986f2de92cd9bb58308439637307aad116760e04d.885aa8759f26cb7682e67a9df01c90fc	CEO OpenWeb	admin	Western Cape	t	2025-07-18 14:24:30.463065	\N	CEO	OpenWeb	0821234567	Western Cape
4	ceo@openweb.email	ceo@openweb.email	c008b911c3c9b0704c6f1d2c6d8fcb1e9ba34a4e5b76b82f40eb798313b6c5b3cd33e284075ecb8cec3b4368b01c90c6ce1b9e851b37019875fe2050342b1772.959356c2b8987cc9c8d9c439dc55fb64	Keoma	client	kwazulu-natal	t	2025-07-18 15:56:41.87223	\N	Keoma		0826987888	kwazulu-natal
\.


--
-- Data for Name: whatsapp_groups; Type: TABLE DATA; Schema: public; Owner: neondb_owner
--

COPY public.whatsapp_groups (id, name, description, group_url, member_count, category, is_active, created_at) FROM stdin;
\.


--
-- Name: businesses_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.businesses_id_seq', 1, false);


--
-- Name: contact_submissions_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.contact_submissions_id_seq', 1, false);


--
-- Name: content_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.content_id_seq', 1, false);


--
-- Name: data_deals_customer_email_settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.data_deals_customer_email_settings_id_seq', 1, true);


--
-- Name: data_deals_email_settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.data_deals_email_settings_id_seq', 1, true);


--
-- Name: data_deals_orders_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.data_deals_orders_id_seq', 4, true);


--
-- Name: email_campaigns_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.email_campaigns_id_seq', 1, false);


--
-- Name: email_newsletters_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.email_newsletters_id_seq', 1, true);


--
-- Name: header_tags_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.header_tags_id_seq', 2, true);


--
-- Name: page_layouts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.page_layouts_id_seq', 1, true);


--
-- Name: products_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.products_id_seq', 1, false);


--
-- Name: seo_settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.seo_settings_id_seq', 1, false);


--
-- Name: smtp_config_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.smtp_config_id_seq', 1, true);


--
-- Name: system_settings_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.system_settings_id_seq', 1, true);


--
-- Name: users_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.users_id_seq', 4, true);


--
-- Name: whatsapp_groups_id_seq; Type: SEQUENCE SET; Schema: public; Owner: neondb_owner
--

SELECT pg_catalog.setval('public.whatsapp_groups_id_seq', 1, false);


--
-- Name: businesses businesses_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.businesses
    ADD CONSTRAINT businesses_pkey PRIMARY KEY (id);


--
-- Name: contact_submissions contact_submissions_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.contact_submissions
    ADD CONSTRAINT contact_submissions_pkey PRIMARY KEY (id);


--
-- Name: content content_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.content
    ADD CONSTRAINT content_pkey PRIMARY KEY (id);


--
-- Name: data_deals_customer_email_settings data_deals_customer_email_settings_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.data_deals_customer_email_settings
    ADD CONSTRAINT data_deals_customer_email_settings_pkey PRIMARY KEY (id);


--
-- Name: data_deals_email_settings data_deals_email_settings_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.data_deals_email_settings
    ADD CONSTRAINT data_deals_email_settings_pkey PRIMARY KEY (id);


--
-- Name: data_deals_orders data_deals_orders_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.data_deals_orders
    ADD CONSTRAINT data_deals_orders_pkey PRIMARY KEY (id);


--
-- Name: email_campaigns email_campaigns_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.email_campaigns
    ADD CONSTRAINT email_campaigns_pkey PRIMARY KEY (id);


--
-- Name: email_newsletters email_newsletters_email_key; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.email_newsletters
    ADD CONSTRAINT email_newsletters_email_key UNIQUE (email);


--
-- Name: email_newsletters email_newsletters_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.email_newsletters
    ADD CONSTRAINT email_newsletters_pkey PRIMARY KEY (id);


--
-- Name: header_tags header_tags_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.header_tags
    ADD CONSTRAINT header_tags_pkey PRIMARY KEY (id);


--
-- Name: page_layouts page_layouts_page_name_key; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.page_layouts
    ADD CONSTRAINT page_layouts_page_name_key UNIQUE (page_name);


--
-- Name: page_layouts page_layouts_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.page_layouts
    ADD CONSTRAINT page_layouts_pkey PRIMARY KEY (id);


--
-- Name: products products_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.products
    ADD CONSTRAINT products_pkey PRIMARY KEY (id);


--
-- Name: seo_settings seo_settings_page_name_key; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.seo_settings
    ADD CONSTRAINT seo_settings_page_name_key UNIQUE (page_name);


--
-- Name: seo_settings seo_settings_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.seo_settings
    ADD CONSTRAINT seo_settings_pkey PRIMARY KEY (id);


--
-- Name: session session_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.session
    ADD CONSTRAINT session_pkey PRIMARY KEY (sid);


--
-- Name: smtp_config smtp_config_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.smtp_config
    ADD CONSTRAINT smtp_config_pkey PRIMARY KEY (id);


--
-- Name: system_settings system_settings_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.system_settings
    ADD CONSTRAINT system_settings_pkey PRIMARY KEY (id);


--
-- Name: users users_email_unique; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_email_unique UNIQUE (email);


--
-- Name: users users_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_pkey PRIMARY KEY (id);


--
-- Name: users users_username_unique; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.users
    ADD CONSTRAINT users_username_unique UNIQUE (username);


--
-- Name: whatsapp_groups whatsapp_groups_pkey; Type: CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.whatsapp_groups
    ADD CONSTRAINT whatsapp_groups_pkey PRIMARY KEY (id);


--
-- Name: IDX_session_expire; Type: INDEX; Schema: public; Owner: neondb_owner
--

CREATE INDEX "IDX_session_expire" ON public.session USING btree (expire);


--
-- Name: businesses businesses_created_by_users_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.businesses
    ADD CONSTRAINT businesses_created_by_users_id_fk FOREIGN KEY (created_by) REFERENCES public.users(id);


--
-- Name: content content_author_id_users_id_fk; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.content
    ADD CONSTRAINT content_author_id_users_id_fk FOREIGN KEY (author_id) REFERENCES public.users(id);


--
-- Name: data_deals_customer_email_settings data_deals_customer_email_settings_created_by_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.data_deals_customer_email_settings
    ADD CONSTRAINT data_deals_customer_email_settings_created_by_fkey FOREIGN KEY (created_by) REFERENCES public.users(id);


--
-- Name: data_deals_email_settings data_deals_email_settings_created_by_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.data_deals_email_settings
    ADD CONSTRAINT data_deals_email_settings_created_by_fkey FOREIGN KEY (created_by) REFERENCES public.users(id);


--
-- Name: email_campaigns email_campaigns_sent_by_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.email_campaigns
    ADD CONSTRAINT email_campaigns_sent_by_fkey FOREIGN KEY (sent_by) REFERENCES public.users(id);


--
-- Name: page_layouts page_layouts_created_by_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.page_layouts
    ADD CONSTRAINT page_layouts_created_by_fkey FOREIGN KEY (created_by) REFERENCES public.users(id);


--
-- Name: system_settings system_settings_updated_by_fkey; Type: FK CONSTRAINT; Schema: public; Owner: neondb_owner
--

ALTER TABLE ONLY public.system_settings
    ADD CONSTRAINT system_settings_updated_by_fkey FOREIGN KEY (updated_by) REFERENCES public.users(id);


--
-- Name: DEFAULT PRIVILEGES FOR SEQUENCES; Type: DEFAULT ACL; Schema: public; Owner: cloud_admin
--

ALTER DEFAULT PRIVILEGES FOR ROLE cloud_admin IN SCHEMA public GRANT ALL ON SEQUENCES TO neon_superuser WITH GRANT OPTION;


--
-- Name: DEFAULT PRIVILEGES FOR TABLES; Type: DEFAULT ACL; Schema: public; Owner: cloud_admin
--

ALTER DEFAULT PRIVILEGES FOR ROLE cloud_admin IN SCHEMA public GRANT ALL ON TABLES TO neon_superuser WITH GRANT OPTION;


--
-- PostgreSQL database dump complete
--

