# Business Directory Image Import Script

This script allows admin to automatically import and match images to business directory listings.

## Setup

1. Create the image source directory:
   ```bash
   mkdir images-to-import
   ```

2. Place your business images in the `images-to-import` directory

## Usage

Run the script from the project root:

```bash
node scripts/import-images.js
```

## Features

- **Automatic Matching**: Uses fuzzy string matching to find businesses based on image filenames
- **Manual Review**: Shows potential matches with similarity scores for admin approval
- **Manual Matching**: Allows searching and manual assignment for unmatched images
- **Image Optimization**: Copies images to the proper directory with organized naming
- **Database Updates**: Automatically updates business records with image URLs
- **Progress Tracking**: Shows comprehensive import summary and error reporting
- **Safety Features**: File size limits, format validation, and rollback capability

## Supported Formats

- JPG/JPEG
- PNG
- WebP
- GIF

## File Size Limit

Maximum 5MB per image

## How It Works

1. **Scan**: Finds all valid images in the `images-to-import` directory
2. **Match**: Uses similarity algorithms to match image names to business names
3. **Review**: Shows top 3 matches for each image with similarity scores
4. **Import**: Copies approved images and updates database records
5. **Summary**: Provides detailed report of successful imports and errors

## Example Workflow

```
📸 Image: johns-plumbing-services.jpg
   Potential matches:
   1. John's Plumbing Services (95% match) - Cape Town
   2. Johns Auto Services (78% match) - Johannesburg
   3. Plumbing Solutions (65% match) - Durban
   
   Select match (1-3), 's' to skip, 'q' to quit: 1
   ✅ Import scheduled
```

## Manual Matching

For images without close automatic matches, the script provides manual search:

```
📸 Image: restaurant-logo.jpg
Enter business name to search (or "skip" to skip): mama's kitchen

Search results:
1. Mama's Kitchen & Restaurant - Durban (ID: 1234)
2. Mama's Traditional Food - Cape Town (ID: 5678)

Select business (1-2) or "skip": 1
✅ Import completed
```

## Output Directory

Images are copied to: `public/images/businesses/`

Filename format: `{business-id}-{business-slug}.{extension}`

Example: `1234-johns-plumbing-services.jpg`

## Database Integration

The script automatically updates the `businesses` table:
- Sets `image_url` to the new image path
- Updates `updated_at` timestamp

## Error Handling

The script handles:
- Invalid file formats
- Oversized files
- Database connection errors
- File copy errors
- Duplicate imports

## Requirements

- Node.js
- Database connection
- Write permissions for `public/images/businesses/`
- Images placed in `images-to-import/` directory