import XLSX from 'xlsx';
import { db } from '../server/db.ts';
import { businesses, businessCategories } from '../shared/schema.ts';

async function testSingleFile() {
  console.log('🔬 Testing import with single Excel file...');
  
  // Test with Agriculture file first
  const filePath = './attached_assets/yep-co-za_Agriculture_1753630080604.xlsx';
  
  try {
    const workbook = XLSX.readFile(filePath);
    const sheetName = workbook.SheetNames[0];
    const worksheet = workbook.Sheets[sheetName];
    const data = XLSX.utils.sheet_to_json(worksheet);
    
    console.log(`Found ${data.length} rows in Agriculture file`);
    console.log('Sample row:', Object.keys(data[0]));
    
    // Take just first 5 businesses for testing
    const testData = data.slice(0, 5);
    
    for (let i = 0; i < testData.length; i++) {
      const row = testData[i];
      
      const business = {
        storeId: row.store_id?.toString() || null,
        name: row.Name || row.name || `Test Business ${i+1}`,
        description: row.Description || 'Test description',
        category: 'Agriculture',
        location: row.Location || 'South Africa',
        contactEmail: row.Email || null,
        contactPhone: row.Phone || null,
        website: row.Website || null,
        whatsappNumber: null,
        contactPerson: row['Contact Person'] || null,
        slogan: row.Slogan || null,
        latitude: row.Latitude?.toString() || null,
        longitude: row.Longitude?.toString() || null,
        imageUrl: null,
        originalImageUrl: null,
        isVerified: false,
        rating: 0,
        reviewCount: 0,
        isFeatured: false,
        featuredUntil: null,
        highlightColor: null,
        topPlacement: false,
        topPlacementUntil: null,
        featuredOnHomepage: false,
        homepageViewCount: 0,
        status: 'approved', // Set as approved so they show up immediately
        approvedAt: new Date(),
        approvedBy: null,
        rejectionReason: null,
        createdBy: null
      };
      
      try {
        const result = await db.insert(businesses).values(business).returning();
        console.log(`✅ Inserted: ${business.name} (ID: ${result[0].id})`);
      } catch (error) {
        console.error(`❌ Failed to insert ${business.name}:`, error.message);
      }
    }
    
    // Check total count
    const count = await db.select().from(businesses);
    console.log(`\n📊 Total businesses in database: ${count.length}`);
    
  } catch (error) {
    console.error('Test failed:', error);
  }
}

testSingleFile();