import XLSX from 'xlsx';
import { join } from 'path';

// Inspect the structure of one Excel file
function inspectExcelFile(filepath) {
  console.log(`Inspecting file: ${filepath}`);
  
  const workbook = XLSX.readFile(filepath);
  const sheetName = workbook.SheetNames[0];
  const worksheet = workbook.Sheets[sheetName];
  const data = XLSX.utils.sheet_to_json(worksheet);
  
  console.log(`Sheet name: ${sheetName}`);
  console.log(`Total rows: ${data.length}`);
  
  if (data.length > 0) {
    console.log('\nColumn names:');
    Object.keys(data[0]).forEach((key, index) => {
      console.log(`${index + 1}. "${key}"`);
    });
    
    console.log('\nFirst 3 rows of data:');
    data.slice(0, 3).forEach((row, index) => {
      console.log(`\n--- Row ${index + 1} ---`);
      Object.entries(row).forEach(([key, value]) => {
        console.log(`${key}: ${value}`);
      });
    });
  }
}

// Inspect the first available file
const testFile = join('attached_assets', 'yep-co-za_Agriculture_1753460631863.xlsx');
inspectExcelFile(testFile);