Explore

## LTE Proxy API  ```  1.0.0  ```    ``` OAS 3.0 ```

Proxy service for Broadband LTE API with multi-domain support

[Contact API Support](mailto:support@openweb.co.za)

[ISC](https://opensource.org/licenses/ISC)

Servers

http://api.openweb.live:3000 - Production server

Authorize

### [Sessions](http://api.openweb.live:3000/api-docs/\#/Sessions)

GET
[/proxy/currentSessions](http://api.openweb.live:3000/api-docs/#/Sessions/get_proxy_currentSessions)

Get current sessions for multiple usernames

Retrieve current session information for specified usernames across multiple domains

#### Parameters

Cancel

| Name | Description |
| --- | --- |
| usernames \*<br>string<br>(query) | Comma-separated list of usernames or "All" for all usernames |

Execute

#### Responses

| Code | Description | Links |
| --- | --- | --- |
| 200 | Successful operation<br>Media type<br>application/json<br>Controls `Accept` header.<br>- Example Value<br>- Schema<br>```json<br>{<br>  "ok": true,<br>  "data": [<br>    {<br>      "username": "string",<br>      "session_id": "string",<br>      "ip_address": "string",<br>      "start_time": "string"<br>    }<br>  ]<br>}<br>``` | _No links_ |
| 400 | Bad request<br>Media type<br>application/json<br>- Example Value<br>- Schema<br>```json<br>{<br>  "ok": false,<br>  "error_msg": "Missing required parameter"<br>}<br>``` | _No links_ |

### [Usage](http://api.openweb.live:3000/api-docs/\#/Usage)

GET
[/proxy/monthUsage](http://api.openweb.live:3000/api-docs/#/Usage/get_proxy_monthUsage)

Get monthly usage for multiple usernames

GET
[/proxy/dayUsage](http://api.openweb.live:3000/api-docs/#/Usage/get_proxy_dayUsage)

Get daily usage for multiple usernames

### [Accounts](http://api.openweb.live:3000/api-docs/\#/Accounts)

GET
[/proxy/usernameInfo](http://api.openweb.live:3000/api-docs/#/Accounts/get_proxy_usernameInfo)

Get account information for usernames

GET
[/proxy/accountMap](http://api.openweb.live:3000/api-docs/#/Accounts/get_proxy_accountMap)

Get account mapping for single username

### [Classes](http://api.openweb.live:3000/api-docs/\#/Classes)

GET
[/proxy/getClass](http://api.openweb.live:3000/api-docs/#/Classes/get_proxy_getClass)

Get class information for a realm

### [Operations](http://api.openweb.live:3000/api-docs/\#/Operations)

POST
[/proxy/ownSimSwap](http://api.openweb.live:3000/api-docs/#/Operations/post_proxy_ownSimSwap)

Perform SIM swap operation

POST
[/proxy/queueTopup](http://api.openweb.live:3000/api-docs/#/Operations/post_proxy_queueTopup)

Queue top-up operation

### [MTN](http://api.openweb.live:3000/api-docs/\#/MTN)

GET
[/proxy/getMTNSimUnlockStatus](http://api.openweb.live:3000/api-docs/#/MTN/get_proxy_getMTNSimUnlockStatus)

Get MTN SIM unlock status

POST
[/proxy/unlockMTNSim](http://api.openweb.live:3000/api-docs/#/MTN/post_proxy_unlockMTNSim)

Unlock MTN SIM

#### Schemas

Error

UserInfo

SimSwapRequest

TopupRequest