# Masterfile - Client Data Management System

## Overview

Masterfile is a comprehensive client data management system built for telecommunications service providers. The application manages client information, SIM relationships, and service details across multiple categories including Telkom, MTN Mobile, MTN Fixed, and Axxess services. It features a modern React frontend with a Node.js/Express backend, PostgreSQL database, and robust authentication system.

## System Architecture

### Frontend Architecture
- **Framework**: React 18 with TypeScript
- **Build Tool**: Vite for fast development and optimized builds
- **UI Library**: Shadcn/UI components built on Radix UI primitives
- **Styling**: Tailwind CSS with custom design system
- **State Management**: TanStack Query for server state management
- **Routing**: Wouter for lightweight client-side routing
- **Form Handling**: React Hook Form with Zod validation

### Backend Architecture
- **Runtime**: Node.js 20 with TypeScript
- **Framework**: Express.js for REST API endpoints
- **Database ORM**: Drizzle ORM with PostgreSQL dialect
- **Authentication**: Session-based auth with bcrypt password hashing
- **Session Store**: Express sessions with PostgreSQL store
- **API Structure**: RESTful endpoints with proper error handling

### Database Design
- **Primary Database**: PostgreSQL 16
- **Schema Management**: Drizzle Kit for migrations and schema management
- **Key Tables**:
  - `clients`: Main client information with category-based organization
  - `simswaps`: SIM swap tracking and management
  - `users`: System user authentication and authorization
  - `categories`: Service category definitions
  - `mtn_statistics`: Usage statistics for MTN Fixed clients

## Key Components

### Client Management System
- **Multi-Category Support**: Separate views for Telkom, MTN Mobile, MTN Fixed, Axxess, and Telkom Smart categories
- **Primary/Secondary SIM Relationships**: Special handling for Telkom clients with linked SIM structures
- **Advanced Search & Filtering**: Global search functionality with category-specific filters
- **CRUD Operations**: Full create, read, update, delete operations for all client data

### Authentication & Authorization
- **Session-Based Authentication**: Secure session management with HTTP-only cookies
- **Role-Based Access**: Admin role system with user management capabilities
- **Password Security**: Bcrypt hashing with salt rounds for password protection
- **Auto-Login Prevention**: Secure session validation on all protected routes

### External API Integration
- **MTN Fixed Statistics**: Integration with external APIs for usage data and account information
- **Account Mapping**: Real-time client information retrieval from external services
- **Batch Processing**: Bulk statistics refresh for administrative efficiency
- **Session Tracking**: Current active session monitoring for MTN Fixed clients

### Data Visualization & Reporting
- **Statistics Dashboard**: Real-time metrics and client counts
- **Usage Analytics**: Monthly usage statistics with historical data
- **Export Capabilities**: Planned CSV/Excel export functionality
- **Admin Tools**: Bulk operations and data management utilities

## Data Flow

1. **Client Creation**: Users create clients through category-specific forms with validation
2. **Data Persistence**: Client data is stored in PostgreSQL with proper relationships
3. **Search & Retrieval**: Optimized queries with pagination and filtering
4. **External Data Sync**: MTN Fixed clients sync usage data from external APIs
5. **Statistics Aggregation**: Real-time calculation of system-wide statistics
6. **Session Management**: User sessions managed server-side with database persistence

## External Dependencies

### Frontend Dependencies
- **UI Components**: Radix UI primitives for accessible components
- **Styling**: Tailwind CSS with PostCSS processing
- **Data Fetching**: TanStack Query for server state synchronization
- **Form Validation**: Zod schemas for type-safe validation
- **Icons**: Lucide React for consistent iconography

### Backend Dependencies
- **Database**: Neon PostgreSQL with SSL connection
- **ORM**: Drizzle ORM with node-postgres driver
- **Authentication**: bcryptjs for password hashing
- **Session Management**: express-session with connect-pg-simple
- **Development**: tsx for TypeScript execution, esbuild for production builds

### Development Tools
- **Build System**: Vite with React plugin and Replit integration
- **Type Checking**: TypeScript with strict configuration
- **Linting**: ESLint configuration for code quality
- **Database Tools**: Drizzle Kit for schema management and migrations

## Deployment Strategy

### Development Environment
- **Platform**: Replit with Node.js 20 runtime
- **Database**: External PostgreSQL connection to user-managed instance
- **Hot Reload**: Vite development server with HMR support
- **Environment**: Development mode with debug capabilities

### Database Configuration
**IMPORTANT**: Always use the existing external database. Never create a new database.
- **Database URL**: postgresql://neondb_owner:Maniac20!@userza1004.openweb.direct/masterfile
- **Database Name**: masterfile
- **Host**: userza1004.openweb.direct
- **Port**: 5432
- **User**: neondb_owner
- **Password**: Maniac20!

### Production Build
- **Frontend**: Vite build pipeline generating optimized static assets
- **Backend**: ESBuild compilation to single-file Node.js application
- **Database**: Production PostgreSQL with connection pooling
- **Deployment**: Replit autoscale deployment with health checks

### Configuration Management
- **Environment Variables**: DATABASE_URL for database connection, OPENWEB_API_USERNAME and OPENWEB_API_PASSWORD for OpenWeb API authentication
- **Build Scripts**: Separate development and production command configurations
- **Port Configuration**: Express server on port 5000 with external port 80
- **Static Serving**: Production build serves React app as static files
- **API Security**: Automated token management for OpenWeb API with bearer authentication

## Changelog

```
Changelog:
- July 30, 2025: Version 3.1.6 - COMPREHENSIVE MTN FIXED FUNCTIONALITY IMPLEMENTATION - Added complete feature parity between MTN Mobile and MTN Fixed pages, implemented 6 advanced admin buttons (Test API, Top 15 Users, Bottom 30 Users, Sync & Top 15, Sync 3 Months, Sync Daily Usage), comprehensive error logging with detailed debugging information for all MTN Fixed operations, enhanced frontend mutations with detailed console logging and proper error handling, backend routes with extensive logging including user activity tracking, session details, and error stack traces, all MTN Fixed functionality now ready for API integration with proper authentication and error recovery mechanisms
- July 30, 2025: Version 3.1.3 - ENHANCED BOTTOM 30 FUNCTIONALITY IMPLEMENTATION - Upgraded Bottom 15 functionality to Bottom 30 for comprehensive low-usage analytics across MTN Mobile accounts, expanded user tracking from 15 to 30 users with lowest data consumption, updated all UI elements including button labels, modal titles, loading messages, and backend endpoints to reflect Bottom 30 terminology, enhanced administrative oversight of low-usage accounts with improved visibility and consistent labeling throughout the system
- July 30, 2025: Version 3.1.5 - COMPREHENSIVE OPENWEB API USERNAME HANDLING AND AUTHENTICATION FIXES - Fixed OpenWeb API authentication system with developer-provided credentials (admin/Aq9v!dZp#F2nK3wY), optimized token cache to 23 hours matching 24-hour token lifetime, implemented comprehensive username trimming and formatting across all OpenWeb API endpoints (/api/usage-stats, /api/account-info, /api/current-sessions, /api/mtn-mobile-sessions, /api/mtn-mobile-usage, /api/mtn-mobile-daily-usage/sync-single), added automatic @mobile.is.co.za suffix appending for MTN Mobile accounts, enhanced error handling for malformed usernames, fixed trailing space issues causing 400 errors, all Usage Stats endpoints now working correctly with proper Bearer token authentication and username formatting
- July 29, 2025: Version 3.1.3 - SECURE OPENWEB API AUTHENTICATION IMPLEMENTATION - Added comprehensive authentication system for all OpenWeb API calls using stored credentials, implemented automatic token management with expiry handling and refresh, replaced all direct fetch calls with authenticated requests through OpenWebAuth singleton class, added proper error handling for authentication failures and token renewal, ensures all API calls to openweb.live are now properly authenticated with bearer tokens
- July 22, 2025: Version 3.1.2 - COMPREHENSIVE MTN FIXED USAGE TRACKING SYSTEM - Implemented complete dual usage tracking for MTN Fixed clients including 3-Month Usage History cards ("Radius" and "Client Billable" with x2 multiplier) and Daily Usage Stats breakdown identical to MTN Mobile but with orange color scheme, added Sync Daily Usage button for real-time API data fetching, all usage statistics display client billable amounts (x2 multiplied), comprehensive progress tracking and error handling, automatic data loading for MTN Fixed accounts
- July 21, 2025: Version 3.1.1 - FUP FIELD IMPLEMENTATION AND COMPREHENSIVE ACTIVITY LOGGING - Added FUP (Fair Usage Policy) field display to Telkom client cards, implemented FUP field in both client-edit-modal and sim-edit-modal for proper data entry, created comprehensive user activity logging system with database storage, added Action Log navigation menu and admin interface for monitoring all user actions, established verbose logging for authentication, client management, API usage, and system interactions
- July 18, 2025: Version 3.1.0 - SINGLE ACCOUNT SYNC WITH DEBUGGING IMPLEMENTATION - Replaced batch sync functionality with focused single account processing for MTN Mobile Daily Usage, implemented comprehensive API debugging information display on frontend, created new /api/mtn-mobile-daily-usage/sync-single endpoint for individual account processing, modified sync logic to always process all days from 1st of current month to today, added detailed debugging card showing API request variables, URLs, and response data with real-time insights
- July 16, 2025: Version 3.0.9 - COMPREHENSIVE MTN MOBILE SYNC ENHANCEMENT COMPLETED - Fixed critical sync functionality with verbose error logging and account validation, enhanced getAllMtnMobileAccounts() function to properly format accounts with @mobile.is.co.za and filter invalid entries, added comprehensive API call logging with detailed error response capture and request/response debugging, successfully validated sync with 153 properly formatted accounts from 156 total MTN Mobile clients, implemented intelligent incremental sync that detects last synced date and skips already processed data, added comprehensive test endpoint for API debugging with full request/response monitoring, professional enterprise-level error handling and recovery mechanisms now operational
- July 16, 2025: Version 3.0.9 - Enhanced staff notification display and search functionality - Removed View button from notifications since full content is now displayed with enhanced styling, added View button to search results for comprehensive client details modal, fixed critical MTN Mobile Daily Usage sync bug that prevented data storage due to double URL encoding issue
- July 16, 2025: Version 3.0.9 - Implemented comprehensive batch daily usage sync system for MTN Mobile (GSM) accounts - Replaced slow real-time API calls with intelligent database storage, added batch "Sync Daily Usage" button with live progress tracking, intelligent incremental fetching that detects last synced date and only fetches remaining data, comprehensive error handling and recovery, dual progress bars showing account and day-level progress with real-time status updates
- July 15, 2025: Version 3.0.8 - Implemented comprehensive Staff Notification system - Replaced dashboard stats cards with dynamic staff notifications display, added admin-only Staff Notifications management page, supports up to 3 active notifications with different types (info, success, warning, error) and priorities (low, medium, high), includes full CRUD operations with role-based access control
- July 11, 2025: Added new "Axxess (Fibre Lines)" and "OpenServe (Fibre Lines)" categories with specialized field mapping - Name/Surname (name), Username/B Number (accountNumber), Service Details (serviceDetails), Fibre Speed (msisdn), Status (status), Status 2 (status2) with dedicated pages, navigation, dynamic form labels, and database seeding
- July 5, 2025: Fixed Top 15 Usage feature with account number validation and proper error handling - Added automatic account number trimming to prevent API errors from trailing spaces, enhanced error logging for failed API calls, and improved frontend query system to properly display results after sync completion
- July 5, 2025: Added Top 15 Usage feature for MTN Mobile (GSM) category with bulk sync functionality and leaderboard display showing highest data users
- July 5, 2025: Version 3.0.6 - Enhanced Top 15 Usage feature with automatic changelog popup on first login after version updates
- July 4, 2025: Version 3.0.5 - Added new "Axxess (Telkom)" category and removed database connection display from sidebar
- July 4, 2025: Added new "Axxess (Telkom)" category as a standard category (no primary/secondary features)
- July 4, 2025: Implemented comprehensive role-based access control - Staff users now have read-only access to all information including comments/notes, while only admin users can edit/delete/create
- June 25, 2025: Enhanced client view tracking to include edit button clicks and modal opens across all components
- June 25, 2025: Added view button to MTN Mobile accounts with detailed information modal for easy copy/paste
- June 25, 2025: Version 3.0.4 - Replaced Telkom Client Overview with Recently Viewed Accounts system
- June 25, 2025: Added automatic client view tracking across all pages with usage stats and edit functionality  
- June 25, 2025: Version 3.0.3 - Enhanced unlock functionality with secure backend proxy and comprehensive logging
- June 25, 2025: Initial setup
```

## User Preferences

```
Preferred communication style: Simple, everyday language.
Data Policy: NO mock data anywhere in the system - only use real API integration with authentic data sources.
MTN Fixed Requirements: All sync operations must process ALL accounts, not subsets. Real-time API integration required.
```