import { pool } from "./db";

export async function createStaffNotificationsTable(): Promise<void> {
  try {
    await pool.query(`
      CREATE TABLE IF NOT EXISTS staff_notifications (
        id SERIAL PRIMARY KEY,
        title VARCHAR(255) NOT NULL,
        message TEXT NOT NULL,
        type VARCHAR(50) NOT NULL DEFAULT 'info',
        priority VARCHAR(50) NOT NULL DEFAULT 'medium',
        is_active BOOLEAN DEFAULT true,
        created_by INTEGER NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,
        CONSTRAINT fk_staff_notifications_created_by 
          FOREIGN KEY (created_by) REFERENCES users(id)
      );
    `);
    console.log("Staff notifications table created successfully");
  } catch (error) {
    console.error("Error creating staff notifications table:", error);
  }
}