import { Pool } from 'pg';
import { drizzle } from 'drizzle-orm/node-postgres';
import * as schema from "@shared/schema";

// FORCE use of the external PostgreSQL database - NEVER use Replit database
// Completely ignore any environment variables to ensure we use the correct external database
const EXTERNAL_DATABASE_URL = "postgresql://neondb_owner:Maniac20!@userza1004.openweb.direct:5432/masterfile";

console.log('FORCING use of external database at userza1004.openweb.direct/masterfile');
console.log('Environment DATABASE_URL IGNORED - Using hardcoded external database only');

// Explicitly override any environment database settings
delete process.env.DATABASE_URL;
delete process.env.PGHOST;
delete process.env.PGDATABASE;
delete process.env.PGUSER;
delete process.env.PGPASSWORD;
delete process.env.PGPORT;

export const pool = new Pool({ 
  connectionString: EXTERNAL_DATABASE_URL,
  ssl: {
    rejectUnauthorized: false
  }
});

export const db = drizzle(pool, { schema });

// Verify connection is to the correct database
pool.on('connect', (client) => {
  console.log('Connected to external PostgreSQL database: userza1004.openweb.direct/masterfile');
});