import { db } from "./db";
import { categories } from "@shared/schema";

export async function seedCategories(): Promise<void> {
  try {
    // Check if categories already exist
    const existingCategories = await db.select().from(categories);
    
    if (existingCategories.length > 0) {
      console.log("Categories already exist, skipping seed");
      return;
    }

    // Insert the default categories
    const defaultCategories = [
      { name: "Telkom", isActive: true },
      { name: "MTN Mobile GSM", isActive: true },
      { name: "MTN Fixed", isActive: true },
      { name: "Axxess", isActive: true }
    ];

    await db.insert(categories).values(defaultCategories);
    console.log("Categories seeded successfully");
  } catch (error) {
    console.error("Error seeding categories:", error);
    throw error;
  }
}