export const VERSION = "3.1.3";

export interface ChangelogEntry {
  version: string;
  date: string;
  type: "major" | "minor" | "patch";
  features: string[];
  improvements: string[];
  fixes: string[];
}

export const CHANGELOG: ChangelogEntry[] = [
  {
    version: "3.1.3",
    date: "2025-07-30",
    type: "minor",
    features: [
      "Enhanced Bottom 15 functionality to Bottom 30 for comprehensive low-usage analytics",
      "Expanded MTN Mobile usage tracking to display 30 users with lowest data consumption",
      "Updated all UI elements to reflect Bottom 30 terminology throughout the system"
    ],
    improvements: [
      "Increased visibility of low-usage accounts from 15 to 30 for better administrative oversight",
      "Enhanced modal titles and loading messages to reflect Bottom 30 functionality",
      "Updated backend endpoints and database queries to support 30-user limit",
      "Improved user experience with consistent Bottom 30 labeling across all components"
    ],
    fixes: [
      "Updated all references from Bottom 15 to Bottom 30 for consistency",
      "Fixed modal component props and state management for expanded user list",
      "Resolved UI text inconsistencies in button labels and modal headers"
    ]
  },
  {
    version: "3.1.2",
    date: "2025-07-22",
    type: "minor",
    features: [
      "Implemented comprehensive MTN Fixed usage tracking system with dual billing views",
      "Added complete Daily Usage Stats breakdown for MTN Fixed clients with x2 multiplier",
      "Created 3-Month Usage History cards showing both Radius and Client Billable amounts",
      "Integrated Sync Daily Usage button for real-time API data fetching",
      "Added orange color scheme for MTN Fixed vs purple for MTN Mobile distinction"
    ],
    improvements: [
      "Enhanced MTN Fixed client modal with automatic data loading on open",
      "Added comprehensive progress tracking for sync operations with error handling",
      "Implemented client billable amounts (x2 multiplier) across all MTN Fixed usage statistics",
      "Created consistent API integration between MTN Mobile and MTN Fixed clients",
      "Added detailed daily breakdown with session counts and usage information"
    ],
    fixes: [
      "Fixed sync validation to support both MTN Mobile and MTN Fixed account formats",
      "Resolved 400 Bad Request errors for MTN Fixed accounts in sync operations",
      "Corrected account format validation in both sync endpoint and sync functions",
      "Enhanced API endpoint compatibility for different client account types"
    ]
  },
  {
    version: "3.1.1",
    date: "2025-07-21",
    type: "minor",
    features: [
      "Added FUP (Fair Usage Policy) field display to Telkom client cards",
      "Implemented comprehensive user activity logging system with database storage",
      "Created Action Log navigation menu and admin interface for monitoring all user actions",
      "Added FUP field in both client-edit-modal and sim-edit-modal for proper data entry",
      "Established verbose logging for authentication, client management, API usage, and system interactions"
    ],
    improvements: [
      "Enhanced Telkom client cards with FUP field visibility for better data access",
      "Added secure admin-only access controls for viewing activity logs",
      "Created professional activity timeline with user tracking and detailed metadata",
      "Integrated comprehensive change tracking for all client edit operations",
      "Added IP address and user agent tracking for enhanced security monitoring"
    ],
    fixes: [
      "Fixed database schema and routing syntax errors for proper functionality",
      "Resolved activity logging integration with all client management routes",
      "Fixed DatabaseStorage class implementation with all missing methods",
      "Corrected authentication middleware integration for activity tracking"
    ]
  },
  {
    version: "3.1.0",
    date: "2025-07-18",
    type: "minor",
    features: [
      "Implemented single account sync functionality for MTN Mobile Daily Usage",
      "Added comprehensive API debugging information display on frontend",
      "Created new /api/mtn-mobile-daily-usage/sync-single endpoint for individual account processing",
      "Added detailed debugging card showing API request variables and responses",
      "Integrated real-time sync progress tracking with debugging insights"
    ],
    improvements: [
      "Modified sync logic to process all days from 1st of current month to today",
      "Enhanced debugging display with API call details, request URLs, and response data",
      "Replaced batch sync functionality with focused single account processing",
      "Added comprehensive error handling and logging for sync operations",
      "Improved user experience with detailed sync progress and debug information"
    ],
    fixes: [
      "Fixed sync logic to always start from day 1 of current month instead of incremental sync",
      "Resolved 'already up to date' check preventing complete month sync",
      "Fixed single account sync to process all 18 days of current month properly",
      "Removed polling mechanism and updated UI for real-time debugging display"
    ]
  },
  {
    version: "3.0.9",
    date: "2025-07-16",
    type: "minor",
    features: [
      "Enhanced staff notification display with full title and message visibility",
      "Added 'View' button to search results for comprehensive client details modal",
      "Implemented gradient backgrounds and colored borders for notification prominence",
      "Added client view tracking for search result interactions"
    ],
    improvements: [
      "Removed View button from notifications since full content is now displayed",
      "Enhanced notification styling with larger icons, bold typography, and professional shadows",
      "Color-coded notifications by type (error: red, warning: yellow, success: green, info: blue)",
      "Added search result View button with green styling for clear distinction from Edit button",
      "Improved notification readability with enhanced spacing and typography"
    ],
    fixes: [
      "Fixed critical MTN Mobile Daily Usage sync bug preventing data storage",
      "Resolved double URL encoding issue causing all API calls to fail with 400 Bad Request",
      "Fixed search result modal integration with proper ClientViewModal usage",
      "Enabled full production sync for all 150+ MTN Mobile accounts with comprehensive error handling"
    ]
  },
  {
    version: "3.0.8",
    date: "2025-07-15",
    type: "minor",
    features: [
      "Implemented comprehensive Staff Notification system replacing dashboard stats cards",
      "Added admin-only Staff Notifications management page with full CRUD operations",
      "Created dynamic notification display supporting up to 3 active notifications",
      "Added notification types (info, success, warning, error) with distinct icons and colors",
      "Implemented priority levels (low, medium, high) with color-coded badges",
      "Added role-based access control - only admins can create/edit/delete notifications"
    ],
    improvements: [
      "Enhanced dashboard user experience with vivid, informative staff notifications",
      "Added comprehensive form validation for notification creation and editing",
      "Implemented real-time notification updates with proper cache invalidation",
      "Added accessibility improvements with proper DialogDescription elements",
      "Enhanced admin navigation with Bell icon for Staff Notifications",
      "Optimized notification display with responsive grid layout and truncation"
    ],
    fixes: [
      "Fixed apiRequest parameter order in mutation functions",
      "Resolved accessibility warning for missing dialog descriptions",
      "Fixed notification database schema with proper foreign key constraints",
      "Corrected notification sorting to show newest first with 3-item limit"
    ]
  },
  {
    version: "3.0.7",
    date: "2025-07-11",
    type: "minor",
    features: [
      "Added new 'Axxess (Fibre Lines)' category with specialized fibre line management",
      "Added new 'OpenServe (Fibre Lines)' category with identical fibre line functionality",
      "Implemented dynamic field mapping for fibre line categories (Username/B Number, Fibre Speed)",
      "Created dedicated pages for both fibre line providers with consistent UI patterns"
    ],
    improvements: [
      "Enhanced client edit modal with category-specific field labels and placeholders",
      "Added automated database seeding for new fibre line categories",
      "Improved accessibility with proper DialogDescription for edit modal",
      "Enhanced navigation with Wifi icons for fibre line categories",
      "Consolidated fibre line field mapping: Name/Surname → name, Username/B Number → accountNumber, Fibre Speed → msisdn"
    ],
    fixes: [
      "Fixed accessibility warning for missing dialog descriptions in edit modal",
      "Resolved field mapping consistency across fibre line categories",
      "Fixed category-specific form validation and placeholder text display"
    ]
  },
  {
    version: "3.0.6",
    date: "2025-07-05",
    type: "minor",
    features: [
      "Added comprehensive Top 15 Usage tracking for MTN Mobile (GSM) clients",
      "Implemented bulk sync functionality with OpenWeb API integration",
      "Created dedicated 'mtnmobiletop15' database table for usage statistics",
      "Added Top 15 leaderboard modal displaying highest data users with rankings"
    ],
    improvements: [
      "Enhanced account number validation with automatic trimming to prevent API errors",
      "Added comprehensive error logging with detailed client-by-client tracking",
      "Improved batch processing for bulk statistics refresh across MTN Mobile accounts",
      "Added real-time data usage conversion from bytes to GB for better readability",
      "Enhanced frontend query system to properly display results after sync completion"
    ],
    fixes: [
      "Fixed API errors caused by trailing spaces in account numbers",
      "Resolved 'No valid usernames supplied' errors through proper account validation",
      "Fixed Top 15 modal query loading to automatically refresh after sync completion",
      "Improved error handling for API timeout and connectivity issues",
      "Enhanced data synchronization between frontend and backend for Top 15 feature"
    ]
  },
  {
    version: "3.0.5",
    date: "2025-07-04",
    type: "minor",
    features: [
      "Added 'Axxess (Telkom)' category as a standard category with full client management",
      "Implemented comprehensive role-based access control system",
      "Added sidebar navigation menu item for 'Axxess (Telkom)' category",
      "Enhanced ClientViewModal to display notes/comments for staff users"
    ],
    improvements: [
      "Staff users now have read-only access to all information including comments/notes",
      "Only admin users can perform editing operations (create, edit, delete)",
      "Protected all edit/delete buttons throughout the system with admin-only access",
      "RoleGuard component provides flexible role-based access control"
    ],
    fixes: [
      "Fixed LSP errors in ClientViewModal for proper field display",
      "Corrected database category seeding for new Axxess (Telkom) category",
      "Updated routing system to include new category page"
    ]
  },
  {
    version: "3.0.4",
    date: "2025-06-25",
    type: "patch",
    features: [
      "Replaced Telkom Client Overview with Recently Viewed Accounts system",
      "Added automatic client view tracking across all pages",
      "Enhanced view button for MTN Mobile accounts with detailed information modal"
    ],
    improvements: [
      "Enhanced client view tracking to include edit button clicks and modal opens",
      "Added usage stats and edit functionality to recently viewed system",
      "Improved unlock functionality with secure backend proxy and logging"
    ],
    fixes: [
      "Fixed client view tracking implementation",
      "Resolved modal display issues for account information"
    ]
  },
  {
    version: "3.0.3",
    date: "2025-06-18",
    type: "minor",
    features: [
      "Added MTN Fixed Admin Tools with bulk statistics refresh functionality",
      "Implemented comprehensive Usage Statistics modal with live API integration",
      "Added Account Map feature displaying detailed client information from external APIs",
      "Enhanced search results with Usage Statistics access for MTN Fixed clients",
      "Added Current Active Sessions replacing Timeline Information"
    ],
    improvements: [
      "Integrated external API calls for monthUsage, usernameInfo, and currentSessions",
      "Batch processing for efficient bulk statistics refresh across all MTN Fixed clients",
      "Enhanced admin reporting with no-data usage detection capabilities",
      "Improved error handling for external API integration and data parsing",
      "Added cached statistics system independent of live client data"
    ],
    fixes: [
      "Fixed API response parsing for account information and session data",
      "Resolved session data display formatting and empty state handling",
      "Improved admin tools modal functionality and loading states",
      "Fixed coordinate parsing and location display in Account Map"
    ]
  },
  {
    version: "3.0.2",
    date: "2024-12-17",
    type: "patch",
    features: [
      "Added OpenWeb logo integration to application header",
      "Implemented ultra-compact List View design for maximum data density",
      "Enhanced Primary SIM row layout for optimal screen utilization"
    ],
    improvements: [
      "Significantly reduced Primary SIM row height to fit more results per page",
      "Optimized text spacing and truncation to prevent overlapping",
      "Updated version display across all application components",
      "Streamlined expand/collapse indicators and secondary SIM counters",
      "Enhanced flex layout system for better responsive behavior"
    ],
    fixes: [
      "Resolved text overlap issues in List View Primary SIM rows",
      "Fixed flex layout compression problems causing UI distortion",
      "Corrected spacing inconsistencies in compact display mode",
      "Fixed truncation handling for long client names and data fields"
    ]
  },
  {
    version: "3.0.1",
    date: "2024-12-16",
    type: "minor",
    features: [
      "Added dynamic categories system with database integration",
      "Created new 'Telkom Smartphone Uncapped' category with dedicated page",
      "Implemented comprehensive version tracking system",
      "Added beautiful changelog with detailed version history",
      "Dynamic category selection in Add Client modal"
    ],
    improvements: [
      "Enhanced Add Client modal with scrollable design for better accessibility",
      "Updated all client category pages to use consistent API response structure",
      "Improved search functionality across all client categories",
      "Better error handling for database operations",
      "Streamlined navigation with new 'Telkom Smart' section"
    ],
    fixes: [
      "Fixed API response compatibility across MTN Mobile, MTN Fixed, and Axxess pages",
      "Resolved database schema mismatch between Drizzle ORM and PostgreSQL",
      "Fixed SIM edit modal type errors for checkbox handling",
      "Corrected categories table creation and seeding process",
      "Fixed pagination and search integration issues"
    ]
  },
  {
    version: "3.0.0",
    date: "2024-12-15",
    type: "major",
    features: [
      "Complete rebuild of Masterfile application with modern architecture",
      "PostgreSQL database integration with Drizzle ORM",
      "Custom authentication system with session management",
      "Comprehensive client data management with CRUD operations",
      "Advanced Telkom client relationship mapping (Primary + 9 Secondary SIMs)",
      "Responsive design with Tailwind CSS and shadcn/ui components",
      "Real-time search and filtering capabilities",
      "Reseller client identification with special styling",
      "Multi-category client organization (Telkom, MTN Mobile, MTN Fixed, Axxess)"
    ],
    improvements: [
      "Modern React with TypeScript for type safety",
      "TanStack Query for efficient data fetching and caching",
      "Express.js backend with structured API endpoints",
      "Comprehensive form validation with Zod schemas",
      "Responsive grid layouts for optimal viewing on all devices",
      "Professional UI with consistent design patterns"
    ],
    fixes: [
      "Complete rewrite addresses all legacy system limitations",
      "Improved data integrity with proper database relationships",
      "Enhanced security with session-based authentication",
      "Better performance with optimized queries and caching"
    ]
  },
  {
    version: "2.x",
    date: "2024-11-30",
    type: "major", 
    features: [
      "Legacy system with basic client management",
      "Simple data storage and retrieval",
      "Basic user interface"
    ],
    improvements: [
      "Foundation for client data management needs"
    ],
    fixes: [
      "Various stability and performance issues addressed over time"
    ]
  }
];

export function getVersionInfo() {
  return {
    version: VERSION,
    buildDate: new Date().toISOString(),
    environment: process.env.NODE_ENV || "development"
  };
}