Table of contents Exit focus mode

Ask LearnAsk Learn

Table of contentsAdd to CollectionsAdd to plan[Edit](https://github.com/MicrosoftDocs/azure-ai-docs/blob/main/articles/ai-foundry/how-to/develop/sdk-overview.md)

* * *

#### Share via

[Facebook](https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Flearn.microsoft.com%2Fen-us%2Fazure%2Fai-foundry%2Fhow-to%2Fdevelop%2Fsdk-overview%3Fpivots%3Dprogramming-language-csharp%26WT.mc_id%3Dfacebook) [x.com](https://twitter.com/intent/tweet?original_referer=https%3A%2F%2Flearn.microsoft.com%2Fen-us%2Fazure%2Fai-foundry%2Fhow-to%2Fdevelop%2Fsdk-overview%3Fpivots%3Dprogramming-language-csharp%26WT.mc_id%3Dtwitter&text=%0A%0D%0Ahttps%3A%2F%2Flearn.microsoft.com%2Fen-us%2Fazure%2Fai-foundry%2Fhow-to%2Fdevelop%2Fsdk-overview%3Fpivots%3Dprogramming-language-csharp%26WT.mc_id%3Dtwitter&tw_p=tweetbutton&url=https%3A%2F%2Flearn.microsoft.com%2Fen-us%2Fazure%2Fai-foundry%2Fhow-to%2Fdevelop%2Fsdk-overview%3Fpivots%3Dprogramming-language-csharp%26WT.mc_id%3Dtwitter) [LinkedIn](https://www.linkedin.com/feed/?shareActive=true&text=%0A%0D%0Ahttps%3A%2F%2Flearn.microsoft.com%2Fen-us%2Fazure%2Fai-foundry%2Fhow-to%2Fdevelop%2Fsdk-overview%3Fpivots%3Dprogramming-language-csharp%26WT.mc_id%3Dlinkedin) [Email](mailto:?subject=%5BShared%20Article%5D%20How%20to%20get%20started%20with%20Azure%20AI%20Foundry%20SDK%20-%20Azure%20AI%20Foundry%20%7C%20Microsoft%20Learn&body=%0A%0D%0Ahttps%3A%2F%2Flearn.microsoft.com%2Fen-us%2Fazure%2Fai-foundry%2Fhow-to%2Fdevelop%2Fsdk-overview%3Fpivots%3Dprogramming-language-csharp%26WT.mc_id%3Demail)

* * *

Print

# Azure AI Foundry SDK client libraries

- 07/01/2025

Choose a programming language


C#JavaJavaScriptPython

The Azure AI Foundry SDK is a comprehensive toolchain designed to simplify the development of AI applications on Azure. It enables developers to:

- Access popular models from various model providers through a single interface
- Easily combine together models, data, and AI services to build AI-powered applications
- Evaluate, debug, and improve application quality & safety across development, testing, and production environments

The Azure AI Foundry SDK is a set of client libraries and services designed to work together.

Note

This article applies to a **Foundry project**. The code shown here doesn't work for a **hub based project**. For more information, see [Types of projects](https://learn.microsoft.com/en-us/azure/ai-foundry/what-is-azure-ai-foundry#project-types).

[Section titled: Prerequisites](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/develop/sdk-overview?pivots=programming-language-csharp#prerequisites)

## Prerequisites

- An Azure subscription. If you don't have one, create a [free account](https://azure.microsoft.com/free/).

- [Create a Foundry project](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/create-projects?pivots=fdp-project) if you don't have one already.

- Copy the **Azure AI Foundry project endpoint** in the **Overview** section of your project. You'll use it in a moment.

![Screenshot shows the project overview for a Foundry project.](https://learn.microsoft.com/en-us/azure/ai-foundry/media/how-to/projects/fdp-project-overview.png)



Tip



If you don't see the **Azure AI Foundry project endpoint**, you're using a hub based project. (See [Types of projects](https://learn.microsoft.com/en-us/azure/ai-foundry/what-is-azure-ai-foundry#project-types)). Switch to a Foundry project, or use the preceding steps to create one.

- Sign in with the Azure CLI using the same account that you use to access your project:

Copy




```lang-bash
az login

```


[Section titled: Unified Projects client library](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/develop/sdk-overview?pivots=programming-language-csharp#unified-projects-client-library)

## Unified Projects client library

The Azure AI Foundry Projects client library is a unified library that enables you to use multiple client libraries together by connecting to a single project endpoint.

- Install the project client library

Copy




```lang-bash
pip install azure-ai-projects azure-identity

```

- Create a project client in code. **Copy** the Azure AI Foundry project endpoint from the Overview page of the project and update the connections string value.

Copy




```lang-python
from azure.identity import DefaultAzureCredential
from azure.ai.projects import AIProjectClient

project = AIProjectClient(
    endpoint="your_project_endpoint",  # Replace with your endpoint
    credential=DefaultAzureCredential())

```


Important

Items marked (preview) in this article are currently in public preview. This preview is provided without a service-level agreement, and we don't recommend it for production workloads. Certain features might not be supported or might have constrained capabilities. For more information, see [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/).

- Add these packages to your installation (preview):

  - `com.azure.ai.projects`
  - `com.azure.core`
- Create a project client in code. **Copy** the Azure AI Foundry project endpoint from the Overview page of the project and update the connections string value.

Copy




```lang-java
import com.azure.ai.projects.ProjectsClient;
import com.azure.ai.projects.ProjectsClientBuilder;
import com.azure.core.credential.AzureKeyCredential;

String endpoint ="your_project_endpoint"; // Replace with your endpoint

ProjectsClient projectClient = new ProjectsClientBuilder()
      .credential(new DefaultAzureCredential())
      .endpoint(endpoint)
      .buildClient();

```


Important

Items marked (preview) in this article are currently in public preview. This preview is provided without a service-level agreement, and we don't recommend it for production workloads. Certain features might not be supported or might have constrained capabilities. For more information, see [Supplemental Terms of Use for Microsoft Azure Previews](https://azure.microsoft.com/support/legal/preview-supplemental-terms/).

- Install dependencies (preview):

Copy




```lang-bash
npm install @azure/ai-projects @azure/identity

```

- Create a project client in code. **Copy** the Azure AI Foundry project endpoint from the Overview page of the project and update the connections string value.

Copy




```lang-javascript
import { AIProjectClient } from '@azure/ai-projects';
import { DefaultAzureCredential } from '@azure/identity';

const endpoint = "your_project_endpoint"; // Replace with your actual endpoint
const project = new AIProjectClient(endpoint, new DefaultAzureCredential());

```


- Install packages:

Copy




```lang-bash
dotnet add package Azure.Identity
dotnet add package Azure.Core
dotnet add package Azure.AI.Inference

```

- Create a project client in code. **Copy** the Azure AI Foundry project endpoint from the Overview page of the project and update the connections string value.

Copy




```lang-csharp
using Azure;
using Azure.Identity;
using Azure.AI.Inference;
using Azure.Core;
using Azure.Core.Pipeline;

var endpointUrl = "your_project_endpoint"; // Replace with your actual endpoint
var credential = new DefaultAzureCredential();

AzureAIInferenceClientOptions clientOptions = new AzureAIInferenceClientOptions();
BearerTokenAuthenticationPolicy tokenPolicy = new BearerTokenAuthenticationPolicy(
      credential,
      new string[] { "https://cognitiveservices.azure.com/.default" }
);
clientOptions.AddPolicy(tokenPolicy, HttpPipelinePosition.PerRetry);

var projectClient = new ChatCompletionsClient(
      endpointUrl,
      credential,
      clientOptions
);

```


- Using the project endpoint, you can:
  - [Use Foundry Model](https://learn.microsoft.com/en-us/azure/ai-foundry/quickstarts/get-started-code), including Azure OpenAI
  - [Use Foundry Agent Service](https://learn.microsoft.com/en-us/azure/ai-services/agents/quickstart?context=/azure/ai-foundry/context/context)
  - [Run evaluations in the cloud](https://learn.microsoft.com/en-us/azure/ai-services/openai/how-to/evaluations?context=/azure/ai-foundry/context/context)
  - [Enable tracing for your app](https://learn.microsoft.com/en-us/azure/ai-foundry/concepts/trace)
  - Retrieve endpoints and keys for external resource connections

[Section titled: Azure AI Services client libraries](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/develop/sdk-overview?pivots=programming-language-csharp#azure-ai-services-client-libraries)

## Azure AI Services client libraries

To use Azure AI services, you can use the following client libraries with the endpoints listed on the project homepage.

[Section titled: C# supported services](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/develop/sdk-overview?pivots=programming-language-csharp#c-supported-services)

### C\# supported services

Expand table

| Service | Description | Reference documentation |
| --- | --- | --- |
| ![Speech icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/speech.svg)[Speech](https://learn.microsoft.com/en-us/azure/ai-services/speech-service/) | Add speech to text, text to speech, translation, and speaker recognition capabilities to applications. | • [Speech SDK for .NET](https://learn.microsoft.com/en-us/dotnet/api/microsoft.cognitiveservices.speech?view=azure-dotnet&branch=main&preserve-view=true)<br>• [Speech NuGet package (Speech CLI)](https://www.nuget.org/packages/Microsoft.CognitiveServices.Speech.CLI) |
| ![Content Safety icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/content-safety.svg)[Content Safety](https://learn.microsoft.com/en-us/azure/ai-services/content-safety/) | Detect harmful content in applications and services. | • [Content Safety SDK for .NET](https://learn.microsoft.com/en-us/dotnet/api/overview/azure/ai.contentsafety-readme?view=azure-dotnet&preserve-view=true)<br>• [Content Safety NuGet package](https://www.nuget.org/packages/Azure.AI.ContentSafety/1.0.0) |
| ![Vision icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/vision.svg)[Vision](https://learn.microsoft.com/en-us/azure/ai-services/computer-vision/) | Analyze content in digital images and rich media assets. | • [Vision SDK for .NET](https://learn.microsoft.com/en-us/dotnet/api/overview/azure/AI.Vision.ImageAnalysis-readme?view=azure-dotnet-preview&preserve-view=true)<br>• [Vision NuGet package](https://www.nuget.org/packages/Azure.AI.Vision.ImageAnalysis) |
| ![Language icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/language.svg)[Language](https://learn.microsoft.com/en-us/azure/ai-services/language-service/) | Build applications with natural language understanding capabilities. | • [Language SDK for .NET (text analysis)](https://learn.microsoft.com/en-us/dotnet/api/overview/azure/ai.textanalytics-readme?view=azure-dotnet&preserve-view=true)<br>• [Language NuGet package (text analysis)](https://www.nuget.org/packages/Azure.AI.TextAnalytics)<br>• [Language SDK for .NET (Question Answering)](https://learn.microsoft.com/en-us/dotnet/api/overview/azure/ai.language.questionanswering-readme?view=azure-dotnet&preserve-view=true)<br>• [Language NuGet package (question answering)](https://www.nuget.org/packages/Azure.AI.Language.QuestionAnswering) |
| ![Translator icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/translator.svg)[Translator](https://learn.microsoft.com/en-us/azure/ai-services/translator/) | Use AI-powered translation technology to translate more than 100 in-use, at-risk, and endangered languages and dialects. | • [Translator SDK for .NET (text)](https://learn.microsoft.com/en-us/dotnet/api/overview/azure/ai.translation.text-readme?view=azure-dotnet-preview&preserve-view=true)<br>• [Translator NuGet package (text)](https://www.nuget.org/packages/Azure.AI.Translation.Text/1.0.0-beta.1)<br>• [Translator SDK for .NET (batch)](https://learn.microsoft.com/en-us/dotnet/api/overview/azure/AI.Translation.Document-readme?view=azure-dotnet&preserve-view=true)<br>• [Translator NuGet package (batch)](https://www.nuget.org/packages/Azure.AI.Translation.Document) |
| ![Document Intelligence icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/document-intelligence.svg)[Document Intelligence](https://learn.microsoft.com/en-us/azure/ai-services/document-intelligence/) | Turn documents into intelligent data-driven solutions. | • [Document Intelligence SDK for .NET](https://learn.microsoft.com/en-us/dotnet/api/overview/azure/ai.documentintelligence-readme?view=azure-dotnet-preview&preserve-view=true)<br>• [Document Intelligence NuGet package](https://www.nuget.org/packages/Azure.AI.DocumentIntelligence/1.0.0-beta.1) |
| ![Azure AI Search icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/search.svg)[Azure AI Search](https://learn.microsoft.com/en-us/azure/search/) | Bring AI-powered cloud search to your mobile and web apps. | • [Azure AI Search SDK for .NET](https://learn.microsoft.com/en-us/dotnet/api/overview/azure/search.documents-readme?view=azure-dotnet&preserve-view=true)<br>• [Azure AI Search NuGet package](https://www.nuget.org/packages/Azure.Search.Documents/11.6.0-beta.2) |

[Section titled: Java supported services](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/develop/sdk-overview?pivots=programming-language-csharp#java-supported-services)

### Java supported services

Expand table

| Service | Description | Reference documentation |
| --- | --- | --- |
| ![Speech icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/speech.svg)[Speech](https://learn.microsoft.com/en-us/azure/ai-services/speech-service/) | Add speech to text, text to speech, translation, and speaker recognition capabilities to applications. | • [Speech SDK for Java](https://learn.microsoft.com/en-us/java/api/com.microsoft.cognitiveservices.speech?view=azure-java-stable&branch=main&preserve-view=true)<br>• [Speech Maven package](https://central.sonatype.com/artifact/com.microsoft.cognitiveservices.speech/client-sdk/1.34.0?smo=true) |
| ![Content Safety icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/content-safety.svg)[Content Safety](https://learn.microsoft.com/en-us/azure/ai-services/content-safety/) | Detect harmful content in applications and services. | • [Content Safety SDK for Java](https://learn.microsoft.com/en-us/java/api/overview/azure/ai-contentsafety-readme?view=azure-java-stable&preserve-view=true)<br>• [Content Safety Maven package](https://central.sonatype.com/artifact/com.azure/azure-ai-contentsafety) |
| ![Vision icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/vision.svg) \[Vision\]../../../ai-services/computer-vision/index.yml) | Analyze content in digital images and rich media assets. | • [Vision SDK for Java](https://learn.microsoft.com/en-us/java/api/overview/azure/ai-vision-imageanalysis-readme?view=azure-java-preview&preserve-view=true)<br>• [Vision Maven package](https://central.sonatype.com/artifact/com.azure/azure-ai-vision-imageanalysis) |
| ![Language icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/language.svg)[Language](https://learn.microsoft.com/en-us/azure/ai-services/language-service/) | Build applications with natural language understanding capabilities. | • [Language SDK for Java (text analysis)](https://learn.microsoft.com/en-us/java/api/overview/azure/ai-textanalytics-readme?view=azure-java-stable&preserve-view=true)<br>• [Language Maven package](https://central.sonatype.com/artifact/com.microsoft.azure.cognitiveservices/azure-cognitiveservices-language) |
| ![Translator icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/translator.svg)[Translator](https://learn.microsoft.com/en-us/azure/ai-services/translator/) | Use AI-powered translation technology to translate more than 100 in-use, at-risk, and endangered languages and dialects. | • [Translator SDK for Java (text)](https://learn.microsoft.com/en-us/java/api/overview/azure/ai-translation-text-readme?view=azure-java-preview&preserve-view=true)<br>• [Translator Maven package (text)](https://central.sonatype.com/artifact/com.azure/azure-ai-translation-text) |
| ![Document Intelligence icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/document-intelligence.svg)[Document Intelligence](https://learn.microsoft.com/en-us/azure/ai-services/document-intelligence/) | Turn documents into intelligent data-driven solutions. | • [Document Intelligence SDK for Java](https://learn.microsoft.com/en-us/java/api/overview/azure/ai-documentintelligence-readme?view=azure-java-preview&preserve-view=true)<br>• [Document Intelligence Maven package](https://mvnrepository.com/artifact/com.azure/azure-ai-documentintelligence/1.0.0-beta.1) |
| ![Azure AI Search icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/search.svg)[Azure AI Search](https://learn.microsoft.com/en-us/azure/search/) | Bring AI-powered cloud search to your mobile and web apps. | • [Azure AI Search SDK for Java](https://learn.microsoft.com/en-us/java/api/overview/azure/search-documents-readme?view=azure-java-stable&preserve-view=true)<br>• [Azure AI Search Maven package](https://central.sonatype.com/artifact/com.azure/azure-search-documents/11.7.0-beta.1?smo=true) |

[Section titled: JavaScript Supported Services](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/develop/sdk-overview?pivots=programming-language-csharp#javascript-supported-services)

### JavaScript Supported Services

Expand table

| Service | Description | Reference documentation |
| --- | --- | --- |
| ![Speech icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/speech.svg)[Speech](https://learn.microsoft.com/en-us/azure/ai-services/speech-service/) | Add speech to text, text to speech, translation, and speaker recognition capabilities to applications. | • [Speech SDK for JavaScript](https://learn.microsoft.com/en-us/javascript/api/microsoft-cognitiveservices-speech-sdk/?view=azure-node-latest&branch=main&preserve-view=true)<br>• [Speech npm package](https://www.npmjs.com/package/microsoft-cognitiveservices-speech-sdk) |
| ![Content Safety icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/content-safety.svg)[Content Safety](https://learn.microsoft.com/en-us/azure/ai-services/content-safety/) | Detect harmful content in applications and services. | • [Content Safety SDK for JavaScript](https://learn.microsoft.com/en-us/javascript/api/%40azure-rest/ai-content-safety/?view=azure-node-latest&preserve-view=true)<br>• [Content Safety npm package](https://www.npmjs.com/package/@azure-rest/ai-content-safety/v/1.0.0-beta.1) |
| ![Vision icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/vision.svg)[Vision](https://learn.microsoft.com/en-us/azure/ai-services/computer-vision/) | Analyze content in digital images and rich media assets. | • [Vision SDK for JavaScript](https://learn.microsoft.com/en-us/javascript/api/overview/azure/ai-vision-image-analysis-rest-readme?view=azure-node-preview&preserve-view=true)<br>• [Vision npm package](https://www.npmjs.com/package/@azure-rest/ai-vision-image-analysis/v/1.0.0-beta.2) |
| ![Language icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/language.svg)[Language](https://learn.microsoft.com/en-us/azure/ai-services/language-service/) | Build applications with natural language understanding capabilities. | • [Language SDK for JavaScript (text analysis)](https://learn.microsoft.com/en-us/javascript/api/overview/azure/ai-language-text-readme?view=azure-node-latest&preserve-view=true)<br>• [Language npm package](https://www.npmjs.com/package/@azure/ai-language-text) |
| ![Translator icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/translator.svg)[Translator](https://learn.microsoft.com/en-us/azure/ai-services/translator/) | Use AI-powered translation technology to translate more than 100 in-use, at-risk, and endangered languages and dialects. | • [Translator SDK for JavaScript (text)](https://learn.microsoft.com/en-us/javascript/api/overview/azure/text-translation?view=azure-node-preview&preserve-view=true)<br>• [Translator npm package (text)](https://www.npmjs.com/package/@azure-rest/ai-translation-text/v/1.0.0-beta.1) |
| ![Document Intelligence icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/document-intelligence.svg)[Document Intelligence](https://learn.microsoft.com/en-us/azure/ai-services/document-intelligence/) | Turn documents into intelligent data-driven solutions. | • [Document Intelligence SDK for JavaScript](https://learn.microsoft.com/en-us/javascript/api/overview/azure/ai-document-intelligence-rest-readme?view=azure-node-preview&preserve-view=true)<br>• [Document Intelligence npm package](https://www.npmjs.com/package/@azure-rest/ai-document-intelligence/v/1.0.0-beta.1) |
| ![Azure AI Search icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/search.svg)[Azure AI Search](https://learn.microsoft.com/en-us/azure/search/) | Bring AI-powered cloud search to your mobile and web apps. | • [Azure AI Search SDK for JavaScript](https://learn.microsoft.com/en-us/javascript/api/overview/azure/search-documents-readme?view=azure-node-latest&preserve-view=true)<br>• [Azure AI Search npm package](https://www.npmjs.com/package/@azure/search-documents/v/12.0.0?activeTab=readme) |

[Section titled: Python supported services](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/develop/sdk-overview?pivots=programming-language-csharp#python-supported-services)

### Python supported services

Expand table

| Service | Description | Reference documentation |
| --- | --- | --- |
| ![Speech icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/speech.svg)[Speech](https://learn.microsoft.com/en-us/azure/ai-services/speech-service/) | Add speech to text, text to speech, translation, and speaker recognition capabilities to applications. | • [Speech SDK for Python](https://learn.microsoft.com/en-us/python/api/azure-cognitiveservices-speech/?view=azure-python&branch=main&preserve-view=true)<br>• [Speech PyPi package](https://pypi.org/project/azure-cognitiveservices-speech/) |
| ![Content Safety icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/content-safety.svg)[Content Safety](https://learn.microsoft.com/en-us/azure/ai-services/content-safety/) | Detect harmful content in applications and services. | • [Content Safety SDK for Python](https://learn.microsoft.com/en-us/python/api/overview/azure/ai-contentsafety-readme?view=azure-python&preserve-view=true)<br>• [Content Safety PyPi package](https://pypi.org/project/azure-ai-contentsafety/1.0.0/) |
| ![Vision icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/vision.svg)[Vision](https://learn.microsoft.com/en-us/azure/ai-services/computer-vision/) | Analyze content in digital images and rich media assets. | • [Vision SDK for Python](https://learn.microsoft.com/en-us/python/api/overview/azure/ai-vision-imageanalysis-readme?view=azure-python-preview&preserve-view=true)<br>• [Vision PyPi package](https://pypi.org/project/azure-ai-vision-imageanalysis/) |
| ![Language icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/language.svg)[Language](https://learn.microsoft.com/en-us/azure/ai-services/language-service/) | Build applications with natural language understanding capabilities. | • [Language SDK for Python (text analysis)](https://learn.microsoft.com/en-us/python/api/overview/azure/ai-textanalytics-readme?view=azure-python&preserve-view=true)<br>• [Language PyPi package (text analysis)](https://pypi.org/project/azure-cognitiveservices-language-textanalytics/)<br>• [Language SDK for Python (question answering)](https://learn.microsoft.com/en-us/python/api/overview/azure/ai-language-questionanswering-readme?view=azure-python&preserve-view=true)<br>• [Language PyPi package (question answering)](https://pypi.org/project/azure-ai-language-questionanswering/)<br>• [Language SDK for Python (language conversations)](https://learn.microsoft.com/en-us/python/api/overview/azure/ai-language-conversations-readme?view=azure-python&preserve-view=true)<br>• [Language PyPi package (language conversations)](https://pypi.org/project/azure-ai-language-conversations/) |
| ![Translator icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/translator.svg)[Translator](https://learn.microsoft.com/en-us/azure/ai-services/translator/) | Use AI-powered translation technology to translate more than 100 in-use, at-risk, and endangered languages and dialects. | • [Translator SDK for Python (text)](https://learn.microsoft.com/en-us/python/api/azure-ai-translation-text/azure.ai.translation.text?view=azure-python-preview&preserve-view=true)<br>• [Translator PyPi package (text)](https://pypi.org/project/azure-ai-translation-text/1.0.0b1/)<br>• [Translator SDK for Python (batch)](https://learn.microsoft.com/en-us/python/api/overview/azure/ai-translation-document-readme?view=azure-python&preserve-view=true)<br>• [Translator PyPi package (batch)](https://pypi.org/project/azure-ai-translation-document/1.0.0/) |
| ![Document Intelligence icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/document-intelligence.svg)[Document Intelligence](https://learn.microsoft.com/en-us/azure/ai-services/document-intelligence/) | Turn documents into intelligent data-driven solutions. | • [Document Intelligence SDK for Python](https://learn.microsoft.com/en-us/python/api/overview/azure/ai-documentintelligence-readme?view=azure-python-preview&preserve-view=true)<br>• [Document Intelligence PyPi package](https://pypi.org/project/azure-ai-documentintelligence/1.0.0b1/) |
| ![Azure AI Search icon](https://learn.microsoft.com/en-us/azure/reusable-content/ce-skilling/azure/media/ai-services/search.svg)[Azure AI Search](https://learn.microsoft.com/en-us/azure/search/) | Bring AI-powered cloud search to your mobile and web apps. | • [Azure AI Search SDK for Python](https://learn.microsoft.com/en-us/python/api/overview/azure/search-documents-readme?view=azure-python&preserve-view=true)<br>• [Azure AI Search PyPi package](https://pypi.org/project/azure-search-documents/11.6.0b1/) |

* * *

## Feedback

Was this page helpful?


YesNo

* * *

## Additional resources

Training


Learning path


[Get started with Azure AI Services - Training](https://learn.microsoft.com/en-us/training/paths/get-started-azure-ai/?source=recommendations)

How to get started with Azure AI Services


Certification


[Microsoft Certified: Azure AI Engineer Associate - Certifications](https://learn.microsoft.com/en-us/credentials/certifications/azure-ai-engineer/?source=recommendations)

Design and implement an Azure AI solution using Azure AI services, Azure AI Search, and Azure Open AI.


Ask Learn is an AI assistant that can answer questions, clarify concepts, and define terms using trusted Microsoft documentation.

Please sign in to use Ask Learn.

[Sign in](https://learn.microsoft.com/en-us/azure/ai-foundry/how-to/develop/sdk-overview?pivots=programming-language-csharp#)