import { type ClassValue, clsx } from "clsx"
import { twMerge } from "tailwind-merge"

export function cn(...inputs: ClassValue[]) {
  return twMerge(clsx(inputs))
}

export function formatNumber(num: number): string {
  if (num >= 1000000) {
    return (num / 1000000).toFixed(1) + 'M';
  }
  if (num >= 1000) {
    return (num / 1000).toFixed(1) + 'K';
  }
  return num.toString();
}

export function formatDuration(seconds: number): string {
  const hours = Math.floor(seconds / 3600);
  const minutes = Math.floor((seconds % 3600) / 60);
  const secs = seconds % 60;
  
  if (hours > 0) {
    return `${hours}:${minutes.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}`;
  }
  return `${minutes}:${secs.toString().padStart(2, '0')}`;
}

export function getCooldownStatus(lastReplenishTime: string | null): { 
  isActive: boolean; 
  timeLeft: number; 
  displayText: string;
} {
  if (!lastReplenishTime) {
    return { isActive: false, timeLeft: 0, displayText: 'Ready to replenish' };
  }

  const lastReplenish = new Date(lastReplenishTime).getTime();
  const now = Date.now();
  const cooldownPeriod = 24 * 60 * 60 * 1000; // 24 hours
  const timeLeft = (lastReplenish + cooldownPeriod) - now;

  if (timeLeft > 0) {
    const hours = Math.floor(timeLeft / (1000 * 60 * 60));
    const minutes = Math.floor((timeLeft % (1000 * 60 * 60)) / (1000 * 60));
    return {
      isActive: true,
      timeLeft,
      displayText: `Next replenish: ${hours}h ${minutes}m`
    };
  }

  return { isActive: false, timeLeft: 0, displayText: 'Ready to replenish' };
}
