export interface ChannelStats {
  id: number;
  channelId: string;
  channelName: string;
  channelHandle?: string | null;
  customUrl?: string | null;
  agScore: number;
  totalViews: number;
  subscribers: number;
  watchTimeHours: number;
  lastReplenishTime: string | null;
}

export interface VideoData {
  id: number;
  videoId: string;
  title: string;
  description: string | null;
  thumbnailUrl: string | null;
  views: number;
  duration: string | null;
  publishedAt: string | null;
  algorithmScore: number;
  ctr: number;
  engagementRate: number;
  seoScore: number;
}

export interface AgSession {
  id: number;
  channelId: number;
  videoId?: number;
  sessionType: 'boost' | 'session' | 'replenish';
  duration: number;
  status: 'pending' | 'running' | 'completed' | 'failed';
  progress: number;
  startedAt: string;
  completedAt?: string;
}

export type SessionType = 'boost' | 'session' | 'replenish' | 'devalue' | 'whatsapp';
