// Debug script to test Reddit authentication flow
const { Pool } = require('@neondatabase/serverless');

async function debugRedditAuth() {
  console.log('🔍 REDDIT AUTH DEBUG SCRIPT');
  console.log('================================');
  
  // Check environment variables
  console.log('\n1. Environment Variables:');
  console.log('DATABASE_URL:', process.env.DATABASE_URL ? 'SET' : 'NOT SET');
  console.log('REDDIT_CLIENT_ID:', process.env.REDDIT_CLIENT_ID ? 'SET' : 'NOT SET');
  console.log('REDDIT_CLIENT_SECRET:', process.env.REDDIT_CLIENT_SECRET ? 'SET' : 'NOT SET');
  
  // Test database connection
  console.log('\n2. Database Connection Test:');
  try {
    const pool = new Pool({ connectionString: process.env.DATABASE_URL });
    const result = await pool.query('SELECT COUNT(*) FROM reddit_connections WHERE user_id = 2');
    console.log('✅ Database connection successful');
    console.log('Reddit connections for user 2:', result.rows[0].count);
    
    // Check if reddit_connections table exists and has proper structure
    const tableInfo = await pool.query(`
      SELECT column_name, data_type 
      FROM information_schema.columns 
      WHERE table_name = 'reddit_connections'
      ORDER BY ordinal_position
    `);
    console.log('Reddit connections table structure:', tableInfo.rows);
    
  } catch (error) {
    console.error('❌ Database connection failed:', error.message);
  }
  
  // Test Reddit OAuth URL generation
  console.log('\n3. Reddit OAuth URL Test:');
  try {
    const response = await fetch('http://localhost:5000/api/reddit/auth', {
      method: 'GET',
      redirect: 'manual'
    });
    console.log('OAuth initiation status:', response.status);
    console.log('OAuth redirect location:', response.headers.get('location'));
  } catch (error) {
    console.error('❌ OAuth URL test failed:', error.message);
  }
}

debugRedditAuth().catch(console.error);