# TubeBoost - YouTube Channel Management Platform

## Overview
TubeBoost is a comprehensive multi-platform social media management platform, initially focused on YouTube with planned expansion to Reddit. It aims to help creators achieve sustainable growth through AI-powered optimization, professional growth services, and advanced analytics. The platform combines legitimate boosting services, AI recommendations, and enterprise-grade security systems to enhance content creation and community engagement.

## User Preferences
- Language: English
- Communication Style: Professional and concise
- Technical Level: Comprehensive technical documentation preferred
- Security Priority: High - emphasis on fraud prevention and data protection

## Recent Changes
- **2025-08-02**: ANTHROPIC API KEYS SYSTEM-WIDE UPDATE COMPLETED - Successfully updated both ANTHROPIC_API_KEY_TUBEBOOST (primary) and ANTHROPIC_API_KEY (fallback) environment variables across all system components; fixed database configuration to use environment variables instead of invalid stored API keys; AI service now operating with dual API key redundancy; all AI-powered features including Reddit moderation "Analyze AI" functionality, YouTube optimization advice, and content generation now working correctly with high confidence scores (0.9-0.92) and comprehensive image analysis capabilities

## System Architecture
TubeBoost employs a modern full-stack architecture. The **Frontend** is built with React and TypeScript, utilizing Vite for bundling, Wouter for routing, and shadcn/ui with Tailwind CSS for UI components. State management is handled by TanStack Query, and authentication uses a custom session-based hook.

The **Backend** is developed with Node.js and Express in TypeScript, backed by a PostgreSQL database managed with Drizzle ORM. Authentication is session-based with bcrypt for password hashing. AI integration is central, using Anthropic Claude Sonnet 4 for YouTube optimization advice and comprehensive Reddit moderation responses.

**Key Features**:
- **Multi-Platform & Multi-Channel Management**: Supports YouTube and Reddit, allowing users to manage multiple channels and subreddits from a unified dashboard.
- **AI-Powered Optimization**: Provides personalized video improvement strategies and comprehensive Reddit moderation responses.
- **Growth Services**: Offers legitimate view, subscriber, and Reddit upvote boosting services.
- **Advanced Analytics**: Tracks performance, conducts competitor analysis, and provides detailed Reddit analytics.
- **Enterprise Security**: Incorporates device fingerprinting and fraud prevention with comprehensive logging and admin monitoring.
- **Real-time Monitoring**: Delivers live order status updates and notifications.
- **Point Economy**: A credit-based system manages service usage with automatic deductions.
- **Comprehensive Moderation**: AI-powered Reddit moderation includes automatic human-like response generation, Modmail integration, and conversation management.
- **Reddit Home Feed**: Provides a full Reddit browsing experience with voting, commenting, and content interaction.

## External Dependencies
- **AI Services**: Azure Llama 3.2 90B (for AI content optimization and moderation)
- **YouTube Services**: YouTube Data API v3
- **Reddit Services**: Reddit OAuth API
- **Growth Services**: SMMCost API (for views and subscribers)
- **Reddit Upvote Services**: Redupvotes API
- **Database**: PostgreSQL