// Test script to verify AI moderation system
import https from 'https';
import http from 'http';

const testConfig = {
  host: 'localhost',
  port: 5000,
  path: '/api/test-ai-moderation',
  method: 'POST',
  headers: {
    'Content-Type': 'application/json'
  }
};

const testData = JSON.stringify({
  test: true,
  prompt: "Test AI analysis: Is this system working correctly?"
});

console.log('🤖 Testing AI moderation system...');

const req = http.request(testConfig, (res) => {
  let data = '';
  
  res.on('data', (chunk) => {
    data += chunk;
  });
  
  res.on('end', () => {
    console.log(`📊 Status: ${res.statusCode}`);
    console.log(`📄 Response: ${data}`);
    
    if (res.statusCode === 200) {
      console.log('✅ AI moderation system test successful!');
    } else {
      console.log('❌ AI moderation system test failed');
    }
  });
});

req.on('error', (err) => {
  console.error('❌ Request error:', err.message);
});

req.write(testData);
req.end();